<?php
require_once(DIR_SYSTEM . 'library/me_pdf_invoice/mpdf/autoload.php');
require_once(DIR_SYSTEM . 'library/me_pdf_invoice/phpqrcode/qrlib.php');
class ControllerExtensionMepdfinvoice extends Controller {
	private $error = array();

	public function invoice() {
		
		if(isset($this->request->get['language_id'])){
			$language_id = $this->request->get['language_id'];
		}else{
			$language_id = $this->config->get('config_language_id');
		}
		
		$this->load->model('localisation/language');
		$languages = $this->model_localisation_language->getLanguages();
		foreach($languages as $language){
			if($language['language_id'] == $language_id){
				$language_code = $language['code'];
			}
		}
		
		$language = new Language($language_code);
		$language->load($language_code);
		$language->load('sale/order');
		$language->load('extension/me_pdf_invoice');
		
		$data['text_order_detail'] = $language->get('text_order_detail');	
		$data['text_payment_address'] = $language->get('text_payment_address');	
		$data['text_shipping_address'] = $language->get('text_shipping_address');	
		$data['text_comment'] = $language->get('text_comment');	
		$data['text_telephone'] = $language->get('text_telephone');	
		$data['text_fax'] = $language->get('text_fax');	
		$data['text_email'] = $language->get('text_email');	
		$data['text_website'] = $language->get('text_website');	
		$data['text_invoice_no'] = $language->get('text_invoice_no');	
		$data['text_order_id'] = $language->get('text_order_id');	
		$data['text_payment_method'] = $language->get('text_payment_method');	
		$data['text_shipping_method'] = $language->get('text_shipping_method');	
		$data['text_date_added'] = $language->get('text_date_added');	
		$data['column_product'] = $language->get('column_product');	
		$data['column_model'] = $language->get('column_model');	
		$data['column_quantity'] = $language->get('column_quantity');	
		$data['column_price'] = $language->get('column_price');	
		$data['column_total'] = $language->get('column_total');
		$data['column_image'] = $language->get('column_image');
		$data['column_manufacturer'] = $language->get('column_manufacturer');
		$data['column_sku'] = $language->get('column_sku');
		$data['column_price_ex'] = $language->get('column_price_ex');
		$data['column_total_ex'] = $language->get('column_total_ex');
		$data['column_dimension'] = $language->get('column_dimension');
		$data['text_company_id'] = $language->get('text_company_id');
		$data['text_vat_number'] = $language->get('text_vat_number');
		
		$data['me_pdf_invoice_status'] = $this->config->get('module_me_pdf_invoice_status');		
		$data['me_pdf_invoice_position'] = $this->config->get('module_me_pdf_invoice_position');
		$data['me_pdf_invoice_barcode'] = $this->config->get('module_me_pdf_invoice_barcode');
		$data['shipping_isetting'] = $this->config->get('module_me_pdf_invoice_isetting');
		$data['me_pdf_invoice_company_id'] = $this->config->get('module_me_pdf_invoice_company_id');
		$data['me_pdf_invoice_vat_number'] = $this->config->get('module_me_pdf_invoice_vat_number');
		$me_pdf_invoice_pdfsetting = $this->config->get('module_me_pdf_invoice_pdfsetting');
		$data['me_pdf_invoice_pdfsetting'] = $me_pdf_invoice_pdfsetting;
		$me_pdf_invoice_desc = $this->config->get('module_me_pdf_invoice_desc')[$language_id];

		$data['title'] = $language->get('text_invoice');
		$data['text_invoice'] = $me_pdf_invoice_desc['heading'];
		$data['header_text'] = html_entity_decode($me_pdf_invoice_desc['header']);
		if ($data['header_text'] == '<p><br></p>') $data['header_text'] = '';
		$data['footer_text'] = html_entity_decode($me_pdf_invoice_desc['footer']);
		if ($data['footer_text'] == '<p><br></p>') $data['footer_text'] = '';
		$data['backside_text'] = html_entity_decode($me_pdf_invoice_desc['backside']);
		if ($data['backside_text'] == '<p><br></p>') $data['backside_text'] = '';
		$data['custom_template'] = html_entity_decode($me_pdf_invoice_desc['custom_template']);
		if ($data['custom_template'] == '<p><br></p>') $data['custom_template'] = '';

		if ($this->request->server['HTTPS']) {
			$data['base'] = HTTPS_SERVER;
		} else {
			$data['base'] = HTTP_SERVER;
		}
		
		$this->load->model('tool/image');
		if (is_file(DIR_IMAGE . $this->config->get('module_me_pdf_invoice_image'))) {
			$ext = pathinfo(DIR_IMAGE . $this->config->get('module_me_pdf_invoice_image'), PATHINFO_EXTENSION);
			if($ext == 'jpg'){
				$data['logo'] = $this->model_tool_image->resize($this->config->get('module_me_pdf_invoice_image'), $this->config->get('module_me_pdf_invoice_width'), $this->config->get('module_me_pdf_invoice_height'));
			}else{
				$image = imagecreatefrompng(DIR_IMAGE . $this->config->get('module_me_pdf_invoice_image'));
				$bg = imagecreatetruecolor(imagesx($image), imagesy($image));
				imagefill($bg, 0, 0, imagecolorallocate($bg, 255, 255, 255));
				imagealphablending($bg, TRUE);
				imagecopy($bg, $image, 0, 0, 0, 0, imagesx($image), imagesy($image));
				imagedestroy($image);
				$quality = 50; // 0 = worst / smaller file, 100 = better / bigger file 
				imagejpeg($bg, DIR_IMAGE . "pdfcustomlogo.jpg", $quality);
				imagedestroy($bg);
				$data['logo'] = $this->model_tool_image->resize('pdfcustomlogo.jpg', $this->config->get('module_me_pdf_invoice_width'), $this->config->get('module_me_pdf_invoice_height'));
			}
			$data['pdf_logo'] = parse_url($data['logo'], PHP_URL_PATH);
		} else {
			$data['logo'] = '';
			$data['pdf_logo'] = '';
		}

		$data['direction'] = $language->get('direction');
		$data['lang'] = $language->get('code');

		$this->load->model('sale/order');

		$this->load->model('setting/setting');
		$orders = array();

		if (isset($this->request->post['selected'])) {
			$orders = $this->request->post['selected'];
		} elseif (isset($this->request->get['order_id'])) {
			$orders[] = $this->request->get['order_id'];
		}
		
		$pdf = new \Mpdf\Mpdf([
		    'orientation' => $me_pdf_invoice_pdfsetting['orientation'],
		    'mode' => 'utf-8',
		    'format' => $me_pdf_invoice_pdfsetting['format'],
		    'directionality' => $data['direction']   // force RTL globally
		]);
		// $pdf->SetCreator(PDF_CREATOR);
		// $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
		// $pdf->SetMargins(10, 5, 10,0);
		// $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
		// $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
		// $pdf->setPrintHeader(false);
		// $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
		$lg = Array();
		$lg['a_meta_charset'] = 'UTF-8';
		$lg['a_meta_dir'] = $data['direction'];
		$lg['a_meta_language'] = 'fa';
		$lg['w_page'] = 'page';
		
		// $pdf->setLanguageArray($lg);
		// $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
		if($data['direction'] == 'ltr'){
			$pdf->SetFont($me_pdf_invoice_pdfsetting['font_type'], '', $me_pdf_invoice_pdfsetting['font_size']);
		}else{
			$pdf->SetFont($me_pdf_invoice_pdfsetting['font_type'], '', $me_pdf_invoice_pdfsetting['font_size']);
		}
		$html = '';
		$order_id = '';
		foreach ($orders as $order_id) {
			if($this->config->get('module_me_pdf_invoice_autogenerateinvoice')){
				$invoice_no = $this->createInvoiceNo($order_id);
			}
			$order_info = $this->model_sale_order->getOrder($order_id);

			if ($order_info) {
				$pdf->SetTitle($this->config->get('module_me_pdf_invoice_prefix').$order_id);
				$store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);

				if ($store_info) {
					$store_address = $store_info['config_address'];
					$store_name = $store_info['config_name'];
					$store_email = $store_info['config_email'];
					$store_telephone = $store_info['config_telephone'];
					$store_fax = $store_info['config_fax'];
				} else {
					$store_address = $this->config->get('config_address');
					$store_name = $this->config->get('config_name');
					$store_email = $this->config->get('config_email');
					$store_telephone = $this->config->get('config_telephone');
					$store_fax = $this->config->get('config_fax');
				}
				
				$custom_fields = ''; 
				if($order_info['custom_field'] && !empty($data['shipping_isetting']['custom_field'])){
					$this->load->model('customer/custom_field');
					foreach($order_info['custom_field'] as $custom_field_id => $value){
						if(!empty(trim($value)) && $value !=='' && isset($data['shipping_isetting']['custom_fields'][$custom_field_id])){
							$custom_field_info = $this->model_customer_custom_field->getCustomField($custom_field_id);
							if($custom_field_info){
								$custom_fields .= '<br/>';
								$custom_fields .= $custom_field_info['name'].':'.$value;
							}
						}
					}
				}

				if ($order_info['invoice_no']) {
					$invoice_no = $order_info['invoice_prefix'] . $order_info['invoice_no'];
				} else {
					$invoice_no = '';
				}

				if ($order_info['payment_address_format']) {
					$format = $order_info['payment_address_format'];
					if($data['shipping_isetting']['email']){
						$format .= "\n" . '{email}';
					}
					if($data['shipping_isetting']['telephone']){
						$format .= "\n" . '{telephone}';
					}
				} else {
					$format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}' . "\n" . '{email}' . "\n" . '{telephone}';
				}

				$find = array(
					'{firstname}',
					'{lastname}',
					'{company}',
					'{address_1}',
					'{address_2}',
					'{city}',
					'{postcode}',
					'{zone}',
					'{zone_code}',
					'{country}',
					'{email}',
					'{telephone}'
				);

				$replace = array(
					'firstname' => $order_info['payment_firstname'],
					'lastname'  => $order_info['payment_lastname'],
					'company'   => $order_info['payment_company'],
					'address_1' => $order_info['payment_address_1'],
					'address_2' => $order_info['payment_address_2'],
					'city'      => $order_info['payment_city'],
					'postcode'  => $order_info['payment_postcode'],
					'zone'      => $order_info['payment_zone'],
					'zone_code' => $order_info['payment_zone_code'],
					'country'   => $order_info['payment_country'],
					'email'   => $order_info['email'],
					'telephone'   => $order_info['telephone']
				);

				$payment_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));
				
				$payment_custom_fields = ''; 
				if($order_info['payment_custom_field'] && !empty($data['shipping_isetting']['custom_field'])){
					$this->load->model('customer/custom_field');
					foreach($order_info['payment_custom_field'] as $custom_field_id => $value){
						if(!empty(trim($value)) && $value !=='' && isset($data['shipping_isetting']['custom_fields'][$custom_field_id])){
							$custom_field_info = $this->model_customer_custom_field->getCustomField($custom_field_id);
							if($custom_field_info){
								$payment_custom_fields .= '<br/>';
								$payment_custom_fields .= $custom_field_info['name'].':'.$value;
							}
						}
					}
				}

				if ($order_info['shipping_address_format']) {
					$format = $order_info['shipping_address_format'];
					if($data['shipping_isetting']['email']){
						$format .= "\n" . '{email}';
					}
					if($data['shipping_isetting']['telephone']){
						$format .= "\n" . '{telephone}';
					}
				} else {
					$format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}' . "\n" . '{email}' . "\n" . '{telephone}';
				}

				$find = array(
					'{firstname}',
					'{lastname}',
					'{company}',
					'{address_1}',
					'{address_2}',
					'{city}',
					'{postcode}',
					'{zone}',
					'{zone_code}',
					'{country}',
					'{email}',
					'{telephone}'
				);

				$replace = array(
					'firstname' => $order_info['shipping_firstname'],
					'lastname'  => $order_info['shipping_lastname'],
					'company'   => $order_info['shipping_company'],
					'address_1' => $order_info['shipping_address_1'],
					'address_2' => $order_info['shipping_address_2'],
					'city'      => $order_info['shipping_city'],
					'postcode'  => $order_info['shipping_postcode'],
					'zone'      => $order_info['shipping_zone'],
					'zone_code' => $order_info['shipping_zone_code'],
					'country'   => $order_info['shipping_country'],
					'email'   => $order_info['email'],
					'telephone'   => $order_info['telephone']
				);

				$shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));
				$shipping_custom_fields = ''; 
				if($order_info['shipping_custom_field'] && !empty($data['shipping_isetting']['custom_field'])){
					$this->load->model('customer/custom_field');
					foreach($order_info['shipping_custom_field'] as $custom_field_id => $value){
						if(!empty(trim($value)) && $value !=='' && isset($data['shipping_isetting']['custom_fields'][$custom_field_id])){
							$custom_field_info = $this->model_customer_custom_field->getCustomField($custom_field_id);
							if($custom_field_info){
								$shipping_custom_fields .= '<br/>';
								$shipping_custom_fields .= $custom_field_info['name'].':'.$value;
							}
						}
					}
				}

				$this->load->model('tool/upload');
				$this->load->model('catalog/product');
				$this->load->model('catalog/manufacturer');

				$product_data = array();
				
				$products = $this->model_sale_order->getOrderProducts($order_id);
				foreach ($products as $product) {
					$option_data = array();

					$options = $this->model_sale_order->getOrderOptions($order_id, $product['order_product_id']);

					foreach ($options as $option) {
						if ($option['type'] != 'file') {
							$value = $option['value'];
						} else {
							$upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

							if ($upload_info) {
								$value = $upload_info['name'];
							} else {
								$value = '';
							}
						}
					
						$option_data[] = array(
							'name'  => $option['name'],
							'value' => $value
						);
					}
					
					$product_info = $this->model_catalog_product->getProduct($product['product_id']);
					
					$manufacturer = '';
					$dimension = '';
					$pdf_image = '';
					if ($product_info) {
						if ($product_info['image']) {
							$image = $this->model_tool_image->resize($product_info['image'], 50, 50);
							$pdf_image = parse_url($image, PHP_URL_PATH);
						} else {
							$image = $this->model_tool_image->resize('placeholder.png', 50, 50);
						}
						
						if($product_info['manufacturer_id']){
							$manufacturer_info = $this->model_catalog_manufacturer->getManufacturer($product_info['manufacturer_id']);
							if($manufacturer_info){
								$manufacturer = $manufacturer_info['name'];
							}
						}
						
						$dimension = (float)$product_info['length'].' x '.(float)$product_info['width'].' x '.(float)$product_info['height'];
					}else {
						$image = $this->model_tool_image->resize('placeholder.png', 50, 50);
					}
					
					$product_data[] = array(
						'image'     => $image,
						'pdf_image'     => $pdf_image,
						'name'     => $product['name'],
						'model'    => $product['model'],
						'sku'    => isset($product_info['sku']) ? $product_info['sku'] : '',
						'manufacturer'    => $manufacturer,
						'dimension'    => $dimension,
						'option'   => $option_data,
						'quantity' => $product['quantity'],
						'price'    => $this->currency->format($product['price'] + ($this->config->get('config_tax') ? $product['tax'] : 0), $order_info['currency_code'], $order_info['currency_value']),
						'price_ex'    => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
						'total'    => $this->currency->format($product['total'] + ($this->config->get('config_tax') ? ($product['tax'] * $product['quantity']) : 0), $order_info['currency_code'], $order_info['currency_value']),
						'total_ex'    => $this->currency->format($product['total'], $order_info['currency_code'], $order_info['currency_value'])
					);
				}
				
				$voucher_data = array();
				
				$vouchers = $this->model_sale_order->getOrderVouchers($order_id);

				foreach ($vouchers as $voucher) {
					$voucher_data[] = array(
						'description' => $voucher['description'],
						'amount'      => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value'])
					);
				}

				$total_data = array();
				$totals = $this->model_sale_order->getOrderTotals($order_id);

				foreach ($totals as $total) {
					$total_data[] = array(
						'title' => $total['title'],
						'text'  => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value'])
					);
				}
				
				$invoiceinvoice = HTTP_CATALOG.'index.php?route=extension/me_pdf_invoice&order_id='.$order_id;
				$site_path = str_replace('catalog/','',DIR_CATALOG);
			
				if(!file_exists($site_path.'me_pdf_invoice')){
					mkdir($site_path.'me_pdf_invoice');
				}
				
				$imagepath = $site_path.'me_pdf_invoice/'.$this->config->get('module_me_pdf_invoice_prefix').$order_id.'.pdf';
				$invoice = HTTP_CATALOG.'me_pdf_invoice/'.$this->config->get('module_me_pdf_invoice_prefix').$order_id.'.pdf';
				
				$find = array(
					'{invoice}',
					'{order_id}',
					'{billing_address}',
					'{shipping_address}',
					'{store_name}',
					'{invoice_link}'
				);
				$replace = array(
					$invoice,
					$order_id,
					$payment_address,
					$shipping_address,
					$store_name,
					$invoice
				);
				$qrcode = '';
				if($this->config->get('module_me_pdf_invoice_qrcodetext') && $this->config->get('module_me_pdf_invoice_barcode')){
					$qrcode = str_replace($find,$replace,$this->config->get('module_me_pdf_invoice_qrcodetext'));
					$file_png = DIR_IMAGE.'cache/order_qrcode'.$order_id.'.png';
					QRcode::png($qrcode, $file_png, QR_ECLEVEL_L, 5);
					$qrcode = HTTPS_CATALOG.'image/cache/order_qrcode'.$order_id.'.png';
					$qrcode = parse_url($qrcode, PHP_URL_PATH);
				}
				
				$data = array_merge($data, array(
					'order_id'	       => $order_id,
					'invoice_no'       => $invoice_no,
					'qrcode'       => $qrcode,
					'custom_fields'       => $custom_fields,
					'payment_custom_fields'       => $payment_custom_fields,
					'shipping_custom_fields'       => $shipping_custom_fields,
					'date_added'       => date($language->get('date_format_short'), strtotime($order_info['date_added'])),
					'store_name'       => $order_info['store_name'],
					'store_url'        => rtrim($order_info['store_url'], '/'),
					'store_address'    => nl2br($store_address),
					'store_email'      => $store_email,
					'store_telephone'  => $store_telephone,
					'store_fax'        => $store_fax,
					'firstname'            => $order_info['firstname'],
					'lastname'            => $order_info['lastname'],
					'email'            => $order_info['email'],
					'telephone'        => $order_info['telephone'],
					'shipping_address' => $shipping_address,
					'shipping_method'  => strip_tags($order_info['shipping_method']),
					'payment_address'  => $payment_address,
					'payment_method'   => strip_tags($order_info['payment_method']),
					'product'          => $product_data,
					'voucher'          => $voucher_data,
					'total'            => $total_data,
					'payment_firstname' => $order_info['payment_firstname'],
					'payment_lastname'  => $order_info['payment_lastname'],
					'payment_company'   => $order_info['payment_company'],
					'payment_address_1' => $order_info['payment_address_1'],
					'payment_address_2' => $order_info['payment_address_2'],
					'payment_city'      => $order_info['payment_city'],
					'payment_postcode'  => $order_info['payment_postcode'],
					'payment_zone'      => $order_info['payment_zone'],
					'payment_country'   => $order_info['payment_country'],
					'shipping_firstname' => $order_info['shipping_firstname'],
					'shipping_lastname'  => $order_info['shipping_lastname'],
					'shipping_company'   => $order_info['shipping_company'],
					'shipping_address_1' => $order_info['shipping_address_1'],
					'shipping_address_2' => $order_info['shipping_address_2'],
					'shipping_city'      => $order_info['shipping_city'],
					'shipping_postcode'  => $order_info['shipping_postcode'],
					'shipping_zone'      => $order_info['shipping_zone'],
					'shipping_country'   => $order_info['shipping_country'],
					'comment'          => nl2br($order_info['comment'])
				));

				if ($data['shipping_isetting']['style'] == 4) {
					$data['custom_template'] = $this->customTemplate($data);
				}

				$html = $this->load->view('extension/me_pdf_invoice', $data);
				//print_r($html); die();
				$pdf->AddPage();
				$pdf->writeHTML($html);
				//$pdf->setCustomFooterText($data['footer_text'],$me_pdf_invoice_pdfsetting['font_type'],$me_pdf_invoice_pdfsetting['font_size']);
				
				// if($data['direction'] == 'ltr'){
				// 	$pdf->setRTL(false);
				// }else{
				// 	$pdf->setRTL(true);
				// }
			}
			// if($data['backside_text']){
			// 	$pdf->AddPage();
			// 	$pdf->writeHTML($data['backside_text'], true, 0, true, 0,'');
			// 	$pdf->setCustomFooterText($data['footer_text'],$me_pdf_invoice_pdfsetting['font_type'],$me_pdf_invoice_pdfsetting['font_size']);
			// }
		}
		
		if($me_pdf_invoice_pdfsetting['mode'] == 1){
			$pdf->Output($this->config->get('module_me_pdf_invoice_prefix').$order_id.'.pdf', 'I');
		}elseif($me_pdf_invoice_pdfsetting['mode'] == 2){
			$pdf->Output($this->config->get('module_me_pdf_invoice_prefix').$order_id.'.pdf', 'D');
		}else{
			$pdf->Output($imagepath, 'F');
			$this->response->redirect($this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'], true));
		}
	}

	public function customTemplate($data) {
		$find = array(
			'{store_detail}',
			'{logo}',
			'{order_id}',
			'{invoice_no}',
			'{payment_method}',
			'{shipping_method}',
			'{date_added}',
			'{payment_firstname}',
			'{payment_lastname}',
			'{payment_address}',
			'{payment_city}',
			'{payment_zone}',
			'{payment_country}',
			'{payment_postcode}',
			'{shipping_firstname}',
			'{shipping_lastname}',
			'{shipping_address}',
			'{shipping_city}',
			'{shipping_zone}',
			'{shipping_country}',
			'{shipping_postcode}',
			'{firstname}',
			'{lastname}',
			'{email}',
			'{telephone}',
			'{qrcode}',
			'{products}',
			'{totals}',
			'{comment}',
		);
		$store_detail = '';
		if ($data['shipping_isetting']['store_address']) {
			$store_detail .= '<address><strong>'.$data['store_name'].'</strong><br />'.$data['store_address'].'<br /></address>';
		}
		if ($data['shipping_isetting']['store_telephone']) {
			$store_detail .= $data['store_telephone'].'<br />';
		}
		if ($data['shipping_isetting']['store_email']) {
			$store_detail .= $data['store_email'].'<br />';
		}
		if ($data['shipping_isetting']['store_fax']) {
			$store_detail .= $data['store_fax'].'<br />';
		}
		if ($data['shipping_isetting']['store_fax']) {
			$store_detail .= '<a href="'.$data['store_url'].'">'.$data['store_url'].'</a><br />';
		}

		$logo = '<img src="'.$data['pdf_logo'].'" align="right" class="store_logo" alt="{{ title }}">';
		$qrcode = '<img src="'.$data['qrcode'].'" alt="{{ title }}">';

		$bgcolor = '';
		if ($data['shipping_isetting']['bgcolor']) {
			$bgcolor = 'bgcolor="'.$data['shipping_isetting']['bgcolor'].'"';
		}
		$color = '';
		if ($data['shipping_isetting']['color']) {
			$color = 'color="'.$data['shipping_isetting']['color'].'"';
		}
		$products = '';
		$totals = '';
		$colspan = -1;
		if ($data['product']) {
			$products .= '<table cellspacing="0" cellpadding="'.$data['me_pdf_invoice_pdfsetting']['cell_padding'].'" border="0" style="border:1px solid #ddd;border-collapse:collapse;">';
			$products .= '<thead>';
			$products .= '<tr class="tr-color">';
			if ($data['shipping_isetting']['pimage']) {
				$products .= '<td style="padding: 0.3in;border-right:1px solid #ddd;"'.$bgcolor.''.$color.'><b>'.$data['column_image'].'</b></td>';
				$colspan++;
			}
			if ($data['shipping_isetting']['pname']) {
				$products .= '<td style="padding: 0.3in;border-right:1px solid #ddd;"'.$bgcolor.''.$color.'><b>'.$data['column_product'].'</b></td>';
				$colspan++;
			}
			if ($data['shipping_isetting']['model']) {
				$products .= '<td style="padding: 0.3in;border-right:1px solid #ddd;"'.$bgcolor.''.$color.'><b>'.$data['column_model'].'</b></td>';
				$colspan++;
			}
			if ($data['shipping_isetting']['manufacturer']) {
				$products .= '<td style="padding: 0.3in;border-right:1px solid #ddd;"'.$bgcolor.''.$color.'><b>'.$data['column_manufacturer'].'</b></td>';
				$colspan++;
			}
			if ($data['shipping_isetting']['sku']) {
				$products .= '<td style="padding: 0.3in;border-right:1px solid #ddd;"'.$bgcolor.''.$color.'><b>'.$data['column_sku'].'</b></td>';
				$colspan++;
			}
			if ($data['shipping_isetting']['dimension']) {
				$products .= '<td style="padding: 0.3in;border-right:1px solid #ddd;"'.$bgcolor.''.$color.'><b>'.$data['column_dimension'].'</b></td>';
				$colspan++;
			}
			if ($data['shipping_isetting']['quantity']) {
				$products .= '<td class="text-right" style="padding: 0.3in;border-right:1px solid #ddd;"'.$bgcolor.''.$color.'><b>'.$data['column_quantity'].'</b></td>';
				$colspan++;
			}
			if ($data['shipping_isetting']['unit_price']) {
				$products .= '<td class="text-right" style="padding: 0.3in;border-right:1px solid #ddd;"'.$bgcolor.''.$color.'><b>'.$data['column_price'].'</b></td>';
				$colspan++;
			}
			if ($data['shipping_isetting']['unit_price_ex']) {
				$products .= '<td class="text-right" style="padding: 0.3in;border-right:1px solid #ddd;"'.$bgcolor.''.$color.'><b>'.$data['column_price_ex'].'</b></td>';
				$colspan++;
			}
			if ($data['shipping_isetting']['total']) {
				$products .= '<td class="text-right" style="padding: 0.3in;border-right:1px solid #ddd;"'.$bgcolor.''.$color.'><b>'.$data['column_total'].'</b></td>';
				$colspan++;
			}
			if ($data['shipping_isetting']['total_ex']) {
				$products .= '<td class="text-right" style="padding: 0.3in;border-right:1px solid #ddd;"'.$bgcolor.''.$color.'><b>'.$data['column_total_ex'].'</b></td>';
				$colspan++;
			}

			$products .= '</tr>';
			$products .= '</thead>';
			$products .= '<tbody>';

			foreach ($data['product'] as $product) {
				$products .= '<tr>';
				if ($data['shipping_isetting']['pimage']) {
				$products .= '<td class="text-center" style="border:1px solid #ddd;"><img src="'.$product['pdf_image'].'" alt="'.$product['name'].'" style="width:50px;height:50px;"></td>';
				}
				if ($data['shipping_isetting']['pname']) {
		         $products .= ' <td style="padding: 0.3in;border:1px solid #ddd;">'.$product['name'];
		         if ($product['option']) {
		         	foreach ($product['option'] as $option) {
		         		$products .= '<br />';
		         		$products .= '&nbsp;<small> - '.$option['name'].': '.$option['value'].'</small>';
		         	}
		         }
		          $products .= ' </td>';
					}
				if ($data['shipping_isetting']['model']) {
		          $products .= '<td style="padding: 0.3in;border:1px solid #ddd;">'.$product['model'].'</td>';
				}
				if ($data['shipping_isetting']['manufacturer']) {
		          $products .= '<td style="padding: 0.3in;border:1px solid #ddd;">'.$product['manufacturer'].'</td>';
				}
				if ($data['shipping_isetting']['sku']) {
		          $products .= '<td style="padding: 0.3in;border:1px solid #ddd;">'.$product['sku'].'</td>';
				}
				if ($data['shipping_isetting']['dimension']) {
		          $products .= '<td style="padding: 0.3in;border:1px solid #ddd;">'.$product['dimension'].'</td>';
				}
				if ($data['shipping_isetting']['quantity']) {
		          $products .= '<td class="text-right" style="border:1px solid #ddd;">'.$product['quantity'].'</td>';
				}
				if ($data['shipping_isetting']['unit_price']) {
		          $products .= '<td class="text-right" style="border:1px solid #ddd;">'.$product['price'].'</td>';
				}
				if ($data['shipping_isetting']['unit_price_ex']) {
		          $products .= '<td class="text-right" style="border:1px solid #ddd;">'.$product['price_ex'].'</td>';
				}
				if ($data['shipping_isetting']['total']) {
		          $products .= '<td class="text-right" style="border:1px solid #ddd;">'.$product['total'].'</td>';
				}
				if ($data['shipping_isetting']['total_ex']) {
		          $products .= '<td class="text-right" style="border:1px solid #ddd;">'.$product['total_ex'].'</td>';
				}
				$products .= '</tr>';
			}
			$products .= '</tbody>';
			$products .= '</table>';
		}
		$totals .= '<table cellspacing="0" cellpadding="'.$data['me_pdf_invoice_pdfsetting']['cell_padding'].'" border="0" style="border:1px solid #ddd;border-collapse:collapse;">';
		$totals .= '<thead></thead>';
		$totals .= '<tbody>';
		foreach ($data['total'] as $total) {
			$totals .= '<tr>';
			$totals .= '<td class="text-right" style="border:1px solid #ddd;"colspan="'.$colspan.'"><b>'.$total['title'].'</b></td>';
			$totals .= '<td class="text-right" style="border:1px solid #ddd;">'.$total['text'].'</td>';

			$totals .= '</tr>';
		}

		$totals .= '</tbody>';
		$products .= '</table>';
		
		$replace = array(
			$store_detail,
			$logo,
			$data['order_id'],
			$data['invoice_no'],
			$data['payment_method'],
			$data['shipping_method'],
			$data['date_added'],
			$data['payment_firstname'],
			$data['payment_lastname'],
			$data['payment_address_1'].$data['payment_address_2'],
			$data['payment_city'],
			$data['payment_zone'],
			$data['payment_country'],
			$data['payment_postcode'],
			$data['shipping_firstname'],
			$data['shipping_lastname'],
			$data['shipping_address_1'].$data['shipping_address_2'],
			$data['shipping_city'],
			$data['shipping_zone'],
			$data['shipping_country'],
			$data['shipping_postcode'],
			$data['firstname'],
			$data['lastname'],
			$data['email'],
			$data['telephone'],
			$qrcode,
			$products,
			$totals,
			$data['comment'],
		);

		return str_replace($find,$replace, $data['custom_template']);

	}

	public function shipping() {
		if(isset($this->request->get['language_id'])){
			$language_id = $this->request->get['language_id'];
		}else{
			$language_id = $this->config->get('config_language_id');
		}
		
		$this->load->model('localisation/language');
		$languages = $this->model_localisation_language->getLanguages();
		foreach($languages as $language){
			if($language['language_id'] == $language_id){
				$language_code = $language['code'];
			}
		}
		
		$language = new Language($language_code);
		$language->load($language_code);
		$language->load('sale/order');
		$language->load('extension/me_pdf_invoice');

		$data['title'] = $language->get('text_shipping');
		$data['text_order_detail'] = $language->get('text_order_detail');
		$data['text_telephone'] = $language->get('text_telephone');
		$data['text_email'] = $language->get('text_email');
		$data['text_fax'] = $language->get('text_fax');
		$data['text_website'] = $language->get('text_website');
		$data['text_invoice_no'] = $language->get('text_invoice_no');
		$data['text_order_id'] = $language->get('text_order_id');
		$data['text_shipping_method'] = $language->get('text_shipping_method');
		$data['text_shipping_address'] = $language->get('text_shipping_address');
		$data['text_comment'] = $language->get('text_comment');
		$data['text_date_added'] = $language->get('text_date_added');
		$data['text_contact'] = $language->get('text_contact');
		$data['column_location'] = $language->get('column_location');
		$data['column_reference'] = $language->get('column_reference');
		$data['column_product'] = $language->get('column_product');
		$data['column_weight'] = $language->get('column_weight');
		$data['column_model'] = $language->get('column_model');
		$data['column_sku'] = $language->get('column_sku');
		$data['column_quantity'] = $language->get('column_quantity');
		$data['column_image'] = $language->get('column_image');
		
		$data['text_company_id'] = $language->get('text_company_id');
		$data['text_vat_number'] = $language->get('text_vat_number');
		
		$data['me_pdf_invoice_status'] = $this->config->get('module_me_pdf_invoice_status');		
		$data['me_pdf_invoice_position'] = $this->config->get('module_me_pdf_invoice_position');
		$data['me_pdf_invoice_barcode'] = $this->config->get('module_me_pdf_invoice_barcode');
		$data['shipping_isetting'] = $this->config->get('module_me_pdf_invoice_isetting');
		$data['me_pdf_invoice_company_id'] = $this->config->get('module_me_pdf_invoice_company_id');
		$data['me_pdf_invoice_vat_number'] = $this->config->get('module_me_pdf_invoice_vat_number');
		$me_pdf_invoice_pdfsetting = $this->config->get('module_me_pdf_invoice_pdfsetting');
		$data['shipping_ssetting'] = $this->config->get('module_me_pdf_invoice_ssetting');
		$data['me_pdf_invoice_pdfsetting'] = $me_pdf_invoice_pdfsetting;
		$me_pdf_invoice_desc = $this->config->get('module_me_pdf_invoice_sdesc')[$language_id];
		$data['text_picklist'] = !empty($me_pdf_invoice_desc['heading']) ? $me_pdf_invoice_desc['heading'] : $language->get('text_picklist');
		
		$data['text_invoice'] = $me_pdf_invoice_desc['heading'];
		$data['header_text'] = html_entity_decode($me_pdf_invoice_desc['header']);
		if ($data['header_text'] == '<p><br></p>') $data['header_text'] = '';
		$data['footer_text'] = html_entity_decode($me_pdf_invoice_desc['footer']);
		if ($data['footer_text'] == '<p><br></p>') $data['footer_text'] = '';
		
		if ($this->request->server['HTTPS']) {
			$data['base'] = HTTPS_SERVER;
		} else {
			$data['base'] = HTTP_SERVER;
		}
		
		$this->load->model('tool/image');

		$data['direction'] = $language->get('direction');
		$data['lang'] = $language->get('code');

		$this->load->model('sale/order');

		$this->load->model('catalog/product');

		$this->load->model('setting/setting');

		$orders = array();

		if (isset($this->request->post['selected'])) {
			$orders = $this->request->post['selected'];
		} elseif (isset($this->request->get['order_id'])) {
			$orders[] = $this->request->get['order_id'];
		}
		
		$pdf = new \Mpdf\Mpdf([
		    'orientation' => $me_pdf_invoice_pdfsetting['orientation'],
		    'mode' => 'utf-8',
		    'format' => $me_pdf_invoice_pdfsetting['format'],
		    'directionality' => $data['direction']   // force RTL globally
		]);
		// $lg = Array();
		// $lg['a_meta_charset'] = 'UTF-8';
		// $lg['a_meta_dir'] = $data['direction'];
		// $lg['a_meta_language'] = 'fa';
		// $lg['w_page'] = 'page';
			
		// $pdf->setLanguageArray($lg);
		// $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
		if($data['direction'] == 'ltr'){
			$pdf->SetFont($me_pdf_invoice_pdfsetting['font_type'], '', $me_pdf_invoice_pdfsetting['font_size']);
		}else{
			$pdf->SetFont($me_pdf_invoice_pdfsetting['font_type'], '', $me_pdf_invoice_pdfsetting['font_size']);
		}
		
		if (is_file(DIR_IMAGE . $this->config->get('module_me_pdf_invoice_image'))) {
			$ext = pathinfo(DIR_IMAGE . $this->config->get('module_me_pdf_invoice_image'), PATHINFO_EXTENSION);
			if($ext == 'jpg'){
				$data['logo'] = $this->model_tool_image->resize($this->config->get('module_me_pdf_invoice_image'), $this->config->get('module_me_pdf_invoice_width'), $this->config->get('module_me_pdf_invoice_height'));
			}else{
				$image = imagecreatefrompng(DIR_IMAGE . $this->config->get('module_me_pdf_invoice_image'));
				$bg = imagecreatetruecolor(imagesx($image), imagesy($image));
				imagefill($bg, 0, 0, imagecolorallocate($bg, 255, 255, 255));
				imagealphablending($bg, TRUE);
				imagecopy($bg, $image, 0, 0, 0, 0, imagesx($image), imagesy($image));
				imagedestroy($image);
				$quality = 50; // 0 = worst / smaller file, 100 = better / bigger file 
				imagejpeg($bg, DIR_IMAGE . "pdfcustomlogo.jpg", $quality);
				imagedestroy($bg);
				$data['logo'] = $this->model_tool_image->resize('pdfcustomlogo.jpg', $this->config->get('module_me_pdf_invoice_width'), $this->config->get('module_me_pdf_invoice_height'));
			}
			$data['pdf_logo'] = parse_url($data['logo'], PHP_URL_PATH);
		} else {
			$data['logo'] = '';
			$data['pdf_logo'] = '';
		}
		$html = '';
		
		foreach ($orders as $order_id) {
			$order_info = $this->model_sale_order->getOrder($order_id);

			// Make sure there is a shipping method
			if ($order_info && $order_info['shipping_code']) {
				$store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);

				if ($store_info) {
					$store_address = $store_info['config_address'];
					$store_name = $store_info['config_name'];
					$store_email = $store_info['config_email'];
					$store_telephone = $store_info['config_telephone'];
					$store_fax = $store_info['config_fax'];
				} else {
					$store_address = $this->config->get('config_address');
					$store_name = $this->config->get('config_name');
					$store_email = $this->config->get('config_email');
					$store_telephone = $this->config->get('config_telephone');
					$store_fax = $this->config->get('config_fax');
				}
				
				$custom_fields = ''; 
				if($order_info['custom_field'] && !empty($data['shipping_isetting']['custom_field'])){
					$this->load->model('customer/custom_field');
					foreach($order_info['custom_field'] as $custom_field_id => $value){
						if(!empty(trim($value)) && $value !=='' && isset($data['shipping_isetting']['custom_fields'][$custom_field_id])){
							$custom_field_info = $this->model_customer_custom_field->getCustomField($custom_field_id);
							if($custom_field_info){
								$custom_fields .= '<br/>';
								$custom_fields .= $custom_field_info['name'].':'.$value;
							}
						}
					}
				}

				if ($order_info['invoice_no']) {
					$invoice_no = $order_info['invoice_prefix'] . $order_info['invoice_no'];
				} else {
					$invoice_no = '';
				}
				
				if ($order_info['payment_address_format']) {
					$format = $order_info['payment_address_format'];
				} else {
					$format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}' . "\n" . '{email}' . "\n" . '{telephone}';
				}

				$find = array(
					'{firstname}',
					'{lastname}',
					'{company}',
					'{address_1}',
					'{address_2}',
					'{city}',
					'{postcode}',
					'{zone}',
					'{zone_code}',
					'{country}',
					'{email}',
					'{telephone}'
				);

				$replace = array(
					'firstname' => $order_info['payment_firstname'],
					'lastname'  => $order_info['payment_lastname'],
					'company'   => $order_info['payment_company'],
					'address_1' => $order_info['payment_address_1'],
					'address_2' => $order_info['payment_address_2'],
					'city'      => $order_info['payment_city'],
					'postcode'  => $order_info['payment_postcode'],
					'zone'      => $order_info['payment_zone'],
					'zone_code' => $order_info['payment_zone_code'],
					'country'   => $order_info['payment_country'],
					'email'   => $order_info['email'],
					'telephone'   => $order_info['telephone']
				);

				$payment_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

				if ($order_info['shipping_address_format']) {
					$format = $order_info['shipping_address_format'];
				} else {
					$format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
				}

				$find = array(
					'{firstname}',
					'{lastname}',
					'{company}',
					'{address_1}',
					'{address_2}',
					'{city}',
					'{postcode}',
					'{zone}',
					'{zone_code}',
					'{country}'
				);

				$replace = array(
					'firstname' => $order_info['shipping_firstname'],
					'lastname'  => $order_info['shipping_lastname'],
					'company'   => $order_info['shipping_company'],
					'address_1' => $order_info['shipping_address_1'],
					'address_2' => $order_info['shipping_address_2'],
					'city'      => $order_info['shipping_city'],
					'postcode'  => $order_info['shipping_postcode'],
					'zone'      => $order_info['shipping_zone'],
					'zone_code' => $order_info['shipping_zone_code'],
					'country'   => $order_info['shipping_country']
				);

				$shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));
				
				$shipping_custom_fields = ''; 
				if($order_info['shipping_custom_field'] && !empty($data['shipping_ssetting']['custom_field'])){
					$this->load->model('customer/custom_field');
					foreach($order_info['shipping_custom_field'] as $custom_field_id => $value){
						if(!empty(trim($value)) && $value !=='' && isset($data['shipping_ssetting']['custom_fields'][$custom_field_id])){
							$custom_field_info = $this->model_customer_custom_field->getCustomField($custom_field_id);
							if($custom_field_info){
								$shipping_custom_fields .= '<br/>';
								$shipping_custom_fields .= $custom_field_info['name'].':'.$value;
							}
						}
					}
				}

				$this->load->model('tool/upload');

				$product_data = array();

				$products = $this->model_sale_order->getOrderProducts($order_id);

				foreach ($products as $product) {
					$option_weight = '';

					$product_info = $this->model_catalog_product->getProduct($product['product_id']);

					if ($product_info) {
						$option_data = array();

						$options = $this->model_sale_order->getOrderOptions($order_id, $product['order_product_id']);

						foreach ($options as $option) {
							if ($option['type'] != 'file') {
								$value = $option['value'];
							} else {
								$upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

								if ($upload_info) {
									$value = $upload_info['name'];
								} else {
									$value = '';
								}
							}

							$option_data[] = array(
								'name'  => $option['name'],
								'value' => $value
							);

							$product_option_value_info = $this->model_catalog_product->getProductOptionValue($product['product_id'], $option['product_option_value_id']);
							$option_weight = 0;
							if ($product_option_value_info) {
								if ($product_option_value_info['weight_prefix'] == '+') {
									$option_weight += $product_option_value_info['weight'];
								} elseif ($product_option_value_info['weight_prefix'] == '-') {
									$option_weight -= $product_option_value_info['weight'];
								}
							}
						}
						
						if ($product_info['image']) {
							$image = $this->model_tool_image->resize($product_info['image'], 50, 50);
							$pdf_image = parse_url($image, PHP_URL_PATH);
						} else {
							$image = $this->model_tool_image->resize('placeholder.png', 50, 50);
						}

						$product_data[] = array(
							'name'     => $product['name'],
							'image'     => $image,
							'pdf_image'     => $pdf_image,
							'model'    => $product['model'],
							'option'   => $option_data,
							'quantity' => $product['quantity'],
							'location' => $product_info['location'],
							'sku'      => $product_info['sku'],
							'upc'      => $product_info['upc'],
							'ean'      => $product_info['ean'],
							'jan'      => $product_info['jan'],
							'isbn'     => $product_info['isbn'],
							'mpn'      => $product_info['mpn'],
							'weight'   => $this->weight->format(($product_info['weight'] + (float)$option_weight) * $product['quantity'], $product_info['weight_class_id'], $language->get('decimal_point'), $language->get('thousand_point'))
						);
					}
				}
				
				$site_path = str_replace('catalog/','',DIR_CATALOG);
			
				if(!file_exists($site_path.'me_pdf_invoice')){
					mkdir($site_path.'me_pdf_invoice');
				}
				
				$imagepath = $site_path.'me_pdf_invoice/'.$this->config->get('module_me_pdf_invoice_slip_prefix').$order_id.'.pdf';
				$invoice = HTTP_CATALOG.'me_pdf_invoice/'.$this->config->get('module_me_pdf_invoice_slip_prefix').$order_id.'.pdf';
				
				$find = array(
					'{invoice}',
					'{order_id}',
					'{billing_address}',
					'{shipping_address}',
					'{store_name}'
				);
				$replace = array(
					$invoice,
					$order_id,
					$payment_address,
					$shipping_address,
					$store_name
				);
				
				$qrcodess = str_replace($find,$replace,$this->config->get('module_me_pdf_invoice_qrcodetext'));
				$style = array(
					'border' => false,
					'padding' => 'auto',
					'fgcolor' => array(0,0,0),
					'bgcolor' => false
				);
				$qrcode = '';
				if($this->config->get('module_me_pdf_invoice_qrcodetext') && $this->config->get('module_me_pdf_invoice_barcode')){
					$qrcode = str_replace($find,$replace,$this->config->get('module_me_pdf_invoice_qrcodetext'));
					$file_png = DIR_IMAGE.'cache/order_qrcode'.$order_id.'.png';
					QRcode::png($qrcode, $file_png, QR_ECLEVEL_L, 5);
					$qrcode = HTTPS_CATALOG.'image/cache/order_qrcode'.$order_id.'.png';
					$qrcode = parse_url($qrcode, PHP_URL_PATH);
				}
	$data['total'] = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value']);
	
				$data = array_merge($data, array(
					'order_id'	       => $order_id,
					'invoice_no'       => $invoice_no,
					'qrcode'       => $qrcode,
					'custom_fields'       => $custom_fields,
					'shipping_custom_fields'       => $shipping_custom_fields,
					'date_added'       => date($language->get('date_format_short'), strtotime($order_info['date_added'])),
'total'            => $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value']),
'payment_code'     => $order_info['payment_code'],
					'store_name'       => $order_info['store_name'],
					'store_url'        => rtrim($order_info['store_url'], '/'),
					'store_address'    => nl2br($store_address),
					'store_email'      => $store_email,
					'store_telephone'  => $store_telephone,
					'store_fax'  => $store_fax,
					'email'            => $order_info['email'],
					'telephone'        => $order_info['telephone'],
					'shipping_address' => $shipping_address,
					'shipping_method'  => strip_tags($order_info['shipping_method']),
					'product'          => $product_data,
					'comment'          => nl2br($order_info['comment'])
				));
				
				$html = $this->load->view('extension/me_pdf_shipping', $data);
				$pdf->AddPage();
				$pdf->writeHTML($html);
				//$pdf->setCustomFooterText($data['footer_text'],$me_pdf_invoice_pdfsetting['font_type'],$me_pdf_invoice_pdfsetting['font_size']);
				
				// if($data['direction'] == 'ltr'){
				// 	$pdf->setRTL(false);
				// }else{
				// 	$pdf->setRTL(true);
				// }
			}
		}
		// ob_end_clean();
		if($me_pdf_invoice_pdfsetting['mode'] == 1){
			$pdf->Output($this->config->get('module_me_pdf_invoice_slip_prefix').$order_id.'.pdf', 'I');
		}elseif($me_pdf_invoice_pdfsetting['mode'] == 2){
			$pdf->Output($this->config->get('module_me_pdf_invoice_slip_prefix').$order_id.'.pdf', 'D');
		}else{
			$pdf->Output($imagepath, 'F');
			$this->response->redirect($this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'], true));
		}

		//$this->response->setOutput($this->load->view('extension/me_pdf_shipping', $data));
	}

	public function createInvoiceNo($order_id) {
		$this->load->model('sale/order');
		$order_info = $this->model_sale_order->getOrder($order_id);

		if ($order_info && !$order_info['invoice_no']) {
			$query = $this->db->query("SELECT MAX(invoice_no) AS invoice_no FROM `" . DB_PREFIX . "order` WHERE invoice_prefix = '" . $this->db->escape($order_info['invoice_prefix']) . "'");

			if ($query->row['invoice_no']) {
				$invoice_no = $query->row['invoice_no'] + 1;
			} else {
				$invoice_no = 1;
			}

			if ($this->config->get('module_me_pdf_invoice_generateinvoicesame')) {
				$invoice_no = $order_id;
			}

			$this->db->query("UPDATE `" . DB_PREFIX . "order` SET invoice_no = '" . (int)$invoice_no . "', invoice_prefix = '" . $this->db->escape($order_info['invoice_prefix']) . "' WHERE order_id = '" . (int)$order_id . "'");

			return $order_info['invoice_prefix'] . $invoice_no;
		}
	}
}
