<?php
class ControllerExtensionModuleMepdfinvoice extends Controller {
	private $error = array();

	public function install() {
		$this->load->model('user/user_group');
		$this->model_user_user_group->addPermission($this->user->getGroupId(), 'access', 'extension/me_pdf_invoice');
			$this->model_user_user_group->addPermission($this->user->getGroupId(), 'modify', 'extension/me_pdf_invoice');
	}

	public function index() {
		$this->load->language('extension/module/me_pdf_invoice');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('module_me_pdf_invoice', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true));
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/module/me_pdf_invoice', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['action'] = $this->url->link('extension/module/me_pdf_invoice', 'user_token=' . $this->session->data['user_token'], true);

		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);
		
		###  Get All Languages
		$this->load->model('localisation/language');
		$data['languages'] = $this->model_localisation_language->getLanguages();
		
		### Get All Customer Fields
		$this->load->model('customer/custom_field');
		$data['custom_fields'] = $this->model_customer_custom_field->getCustomFields();
		
		### General Tab
		if (isset($this->request->post['module_me_pdf_invoice_status'])) {
			$data['module_me_pdf_invoice_status'] = $this->request->post['module_me_pdf_invoice_status'];
		} else {
			$data['module_me_pdf_invoice_status'] = $this->config->get('module_me_pdf_invoice_status');
		}
		
		if (isset($this->request->post['module_me_pdf_invoice_image'])) {
			$data['module_me_pdf_invoice_image'] = $this->request->post['module_me_pdf_invoice_image'];
		} else {
			$data['module_me_pdf_invoice_image'] = $this->config->get('module_me_pdf_invoice_image');
		}
		
		$this->load->model('tool/image');

		if (isset($data['module_me_pdf_invoice_image']) && is_file(DIR_IMAGE . $data['module_me_pdf_invoice_image'])) {
			$data['thumb'] = $this->model_tool_image->resize($data['module_me_pdf_invoice_image'], 100, 100);
		} else {
			$data['thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}

		$data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		
		if (isset($this->request->post['module_me_pdf_invoice_width'])) {
			$data['module_me_pdf_invoice_width'] = $this->request->post['module_me_pdf_invoice_width'];
		} else {
			$data['module_me_pdf_invoice_width'] = $this->config->get('module_me_pdf_invoice_width');
		}
		
		if (isset($this->request->post['module_me_pdf_invoice_height'])) {
			$data['module_me_pdf_invoice_height'] = $this->request->post['module_me_pdf_invoice_height'];
		} else {
			$data['module_me_pdf_invoice_height'] = $this->config->get('module_me_pdf_invoice_height');
		}
		
		if (isset($this->request->post['module_me_pdf_invoice_position'])) {
			$data['module_me_pdf_invoice_position'] = $this->request->post['module_me_pdf_invoice_position'];
		} else {
			$data['module_me_pdf_invoice_position'] = $this->config->get('module_me_pdf_invoice_position');
		}
		
		if (isset($this->request->post['module_me_pdf_invoice_barcode'])) {
			$data['module_me_pdf_invoice_barcode'] = $this->request->post['module_me_pdf_invoice_barcode'];
		} else {
			$data['module_me_pdf_invoice_barcode'] = $this->config->get('module_me_pdf_invoice_barcode');
		}
		
		if (isset($this->request->post['module_me_pdf_invoice_qrcodetext'])) {
			$data['module_me_pdf_invoice_qrcodetext'] = $this->request->post['module_me_pdf_invoice_qrcodetext'];
		} else {
			$data['module_me_pdf_invoice_qrcodetext'] = $this->config->get('module_me_pdf_invoice_qrcodetext');
		}
		
		if (isset($this->request->post['module_me_pdf_invoice_prefix'])) {
			$data['module_me_pdf_invoice_prefix'] = $this->request->post['module_me_pdf_invoice_prefix'];
		} else {
			$data['module_me_pdf_invoice_prefix'] = $this->config->get('module_me_pdf_invoice_prefix');
		}
		
		if (isset($this->request->post['module_me_pdf_invoice_sendadmin'])) {
			$data['module_me_pdf_invoice_sendadmin'] = $this->request->post['module_me_pdf_invoice_sendadmin'];
		} else {
			$data['module_me_pdf_invoice_sendadmin'] = $this->config->get('module_me_pdf_invoice_sendadmin');
		}
		
		if (isset($this->request->post['module_me_pdf_invoice_sendcustomer'])) {
			$data['module_me_pdf_invoice_sendcustomer'] = $this->request->post['module_me_pdf_invoice_sendcustomer'];
		} else {
			$data['module_me_pdf_invoice_sendcustomer'] = $this->config->get('module_me_pdf_invoice_sendcustomer');
		}
		
		if (isset($this->request->post['module_me_pdf_invoice_showonorderpage'])) {
			$data['module_me_pdf_invoice_showonorderpage'] = $this->request->post['module_me_pdf_invoice_showonorderpage'];
		} else {
			$data['module_me_pdf_invoice_showonorderpage'] = $this->config->get('module_me_pdf_invoice_showonorderpage');
		}
		
		if (isset($this->request->post['module_me_pdf_invoice_showonaccountorderpage'])) {
			$data['module_me_pdf_invoice_showonaccountorderpage'] = $this->request->post['module_me_pdf_invoice_showonaccountorderpage'];
		} else {
			$data['module_me_pdf_invoice_showonaccountorderpage'] = $this->config->get('module_me_pdf_invoice_showonaccountorderpage');
		}
		
		if (isset($this->request->post['module_me_pdf_invoice_autogenerateinvoice'])) {
			$data['module_me_pdf_invoice_autogenerateinvoice'] = $this->request->post['module_me_pdf_invoice_autogenerateinvoice'];
		} else {
			$data['module_me_pdf_invoice_autogenerateinvoice'] = $this->config->get('module_me_pdf_invoice_autogenerateinvoice');
		}
		
		if (isset($this->request->post['module_me_pdf_invoice_attach_pdf_status'])) {
			$data['module_me_pdf_invoice_attach_pdf_status'] = $this->request->post['module_me_pdf_invoice_attach_pdf_status'];
		} else {
			$data['module_me_pdf_invoice_attach_pdf_status'] = $this->config->get('module_me_pdf_invoice_attach_pdf_status');
		}
		
		if (isset($this->request->post['module_me_pdf_invoice_company_id'])) {
			$data['module_me_pdf_invoice_company_id'] = $this->request->post['module_me_pdf_invoice_company_id'];
		} else {
			$data['module_me_pdf_invoice_company_id'] = $this->config->get('module_me_pdf_invoice_company_id');
		}
		
		if (isset($this->request->post['module_me_pdf_invoice_vat_number'])) {
			$data['module_me_pdf_invoice_vat_number'] = $this->request->post['module_me_pdf_invoice_vat_number'];
		} else {
			$data['module_me_pdf_invoice_vat_number'] = $this->config->get('module_me_pdf_invoice_vat_number');
		}

		if (isset($this->request->post['module_me_pdf_invoice_generateinvoicesame'])) {
			$data['module_me_pdf_invoice_generateinvoicesame'] = $this->request->post['module_me_pdf_invoice_generateinvoicesame'];
		} else {
			$data['module_me_pdf_invoice_generateinvoicesame'] = $this->config->get('module_me_pdf_invoice_generateinvoicesame');
		}
		
		### Invoice Setting Tab
		if (isset($this->request->post['module_me_pdf_invoice_isetting'])) {
			$data['module_me_pdf_invoice_isetting'] = $this->request->post['module_me_pdf_invoice_isetting'];
		} else {
			$data['module_me_pdf_invoice_isetting'] = $this->config->get('module_me_pdf_invoice_isetting');
		}
		
		### Invoice Content Setting Tab
		if (isset($this->request->post['module_me_pdf_invoice_desc'])) {
			$data['module_me_pdf_invoice_desc'] = $this->request->post['module_me_pdf_invoice_desc'];
		} else {
			$data['module_me_pdf_invoice_desc'] = $this->config->get('module_me_pdf_invoice_desc');
		}
		
		### Shipping Slip Tab
		if (isset($this->request->post['module_me_pdf_invoice_slip'])) {
			$data['module_me_pdf_invoice_slip'] = $this->request->post['module_me_pdf_invoice_slip'];
		} else {
			$data['module_me_pdf_invoice_slip'] = $this->config->get('module_me_pdf_invoice_slip');
		}
		
		if (isset($this->request->post['module_me_pdf_invoice_slip_prefix'])) {
			$data['module_me_pdf_invoice_slip_prefix'] = $this->request->post['module_me_pdf_invoice_slip_prefix'];
		} else {
			$data['module_me_pdf_invoice_slip_prefix'] = $this->config->get('module_me_pdf_invoice_slip_prefix');
		}
	
		if (isset($this->request->post['module_me_pdf_invoice_ssetting'])) {
			$data['module_me_pdf_invoice_ssetting'] = $this->request->post['module_me_pdf_invoice_ssetting'];
		} else {
			$data['module_me_pdf_invoice_ssetting'] = $this->config->get('module_me_pdf_invoice_ssetting');
		}
		
		### Shipping Slip Content Setting Tab
		if (isset($this->request->post['module_me_pdf_invoice_sdesc'])) {
			$data['module_me_pdf_invoice_sdesc'] = $this->request->post['module_me_pdf_invoice_sdesc'];
		} else {
			$data['module_me_pdf_invoice_sdesc'] = $this->config->get('module_me_pdf_invoice_sdesc');
		}
		
		### PDF Style Tab
		if (isset($this->request->post['module_me_pdf_invoice_pdfsetting'])) {
			$data['module_me_pdf_invoice_pdfsetting'] = $this->request->post['module_me_pdf_invoice_pdfsetting'];
		} else {
			$data['module_me_pdf_invoice_pdfsetting'] = $this->config->get('module_me_pdf_invoice_pdfsetting');
		}

		if (isset($this->request->post['module_me_pdf_invoice_alert_email'])) {
			$data['module_me_pdf_invoice_alert_email'] = $this->request->post['module_me_pdf_invoice_alert_email'];
		} else {
			$data['module_me_pdf_invoice_alert_email'] = $this->config->get('module_me_pdf_invoice_alert_email');
		}

		if ($this->request->server['HTTPS']) {
			$data['catalog'] = HTTPS_CATALOG;
		} else {
			$data['catalog'] = HTTP_CATALOG;
		}
		
		### Order Statuses
		$this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/module/me_pdf_invoice', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/module/me_pdf_invoice')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}