<?php

function getContentType()
{
    return isset($_SERVER["CONTENT_TYPE"]) ? trim($_SERVER["CONTENT_TYPE"]) : "";
}

function readJsonInput()
{
    $content = trim(file_get_contents("php://input"));
    $decoded = json_decode($content, true);
    return is_array($decoded) ? $decoded : false;
}

function createSuccessResponse($data)
{
    return [
        "status" => "success",
        "data" => $data,
    ];
}

function sendErrorResponse($httpCode, $message)
{
    header("HTTP/1.1 {$httpCode}");
    header('Content-Type: application/json');
    echo json_encode(["status" => "error", "message" => $message]);
    exit();
}

function checkHttpMethod($expectedMethod)
{
    $method = isset($_SERVER['REQUEST_METHOD']) ? $_SERVER['REQUEST_METHOD'] : '';
    if ($method !== $expectedMethod) {
        sendErrorResponse(405, "Method {$method} Not Allowed. \u{1F61D}");
    }
}

function handleRequest()
{
    checkHttpMethod('PUT');

    if (getContentType() !== "application/json") {
        sendErrorResponse(415, "Content type must be application/json");
    }

    $inputData = readJsonInput();
    if ($inputData === false) {
        sendErrorResponse(400, "Invalid JSON data");
    }

    $responseData = [
        "domain" => $inputData["domain"] ?? '',
        "status" => 1,
        "license_user" => $inputData["license_user"] ?? '',
        "license_key" => $inputData["license_key"] ?? '',
        "license_type" => "Regular License",
        "purchase_date" => date("Y-m-d\\TH:i:s.u", strtotime("now")),
        "supported_until" => date("Y-m-d\\TH:i:s.u", strtotime("+1 year")),
        "support_active" => true,
    ];

    header('Content-Type: application/json');
    echo json_encode(createSuccessResponse($responseData));
    exit();
}

handleRequest();