<?php

function getContentType()
{
    return isset($_SERVER["CONTENT_TYPE"]) ? trim($_SERVER["CONTENT_TYPE"]) : "";
}

function getRequestMethod()
{
    return isset($_SERVER["REQUEST_METHOD"]) ? $_SERVER["REQUEST_METHOD"] : "";
}

function sendErrorResponse($httpCode, $message)
{
    header("HTTP/1.1 " . $httpCode);
    header('Content-Type: application/json');
    echo json_encode(array("status" => "error", "message" => $message));
    exit();
}

function sendSuccessResponse($data)
{
    header('Content-Type: application/json');
    echo json_encode(array("status" => "success", "data" => $data));
    exit();
}

function handleRequest()
{
    if (getRequestMethod() !== "POST") {
        sendErrorResponse(405, "Method Not Allowed");
    }

    if (getContentType() !== "application/json") {
        sendErrorResponse(415, "Unsupported Media Type");
    }

    $response_data = array(
    array(
    "domain" => isset($_SERVER["HTTP_HOST"]) ? $_SERVER["HTTP_HOST"] : "",
    "status" => 1,
    )
    );

    sendSuccessResponse($response_data);
}

handleRequest();