<?php
class ModelToolSeoPackageOpenai extends Model {

	private $auth_key;
	private $testMode = false;
	private $endpoint = 'https://api.openai.com/v1/chat/completions';
	private $model = 'gpt-3.5-turbo';
  
  public function query($prompt) {
    $query = [];
    $query['model'] = $this->config->get('mlseo_chatgpt_model') ? $this->config->get('mlseo_chatgpt_model') : $this->model;
    $query['messages'][0]['role'] = 'user';
    $query['messages'][0]['content'] = $prompt;
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $this->endpoint);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($query));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
      'Authorization: Bearer '.$this->config->get('mlseo_chatgpt_key'),
      'Content-Type: application/json'
    ]);
    
    $result = curl_exec($ch);
    $err = curl_error($ch);
    
    curl_close ($ch);
    
    $res = json_decode($result, true);
    
    if ($err) {
      file_put_contents(DIR_LOGS.'error.log', 'Curl error: '. $err . PHP_EOL, FILE_APPEND | LOCK_EX);
      if ($this->testMode) {
        die('Curl error: ' . $err);
      }
    }
    
    if (!empty($res['error'])) {
      file_put_contents(DIR_LOGS.'error.log', '⚠️ Error: ' . $res['error']['type'] . ' - ' . $res['error']['message'] . PHP_EOL, FILE_APPEND | LOCK_EX);
      if ($this->testMode) {
        die('⚠️ Error: ' . $res['error']['type'] . ' - ' . $res['error']['message']);
      }
    }
    
    if (isset($res['choices'][0]['message']['content'])) {
      return $res['choices'][0]['message']['content'];
    }
    return '';
  }
  
  public function convertLangCode($lang) {
    switch ($lang) {
      case 'ua': $lang = 'uk'; break;
    }
    
    return strtolower(substr($lang, 0, 2));
  }
}