<?php
class ControllerExtensionPaymentKashierCard extends Controller
{
    public function index()
    {
        $this->load->language('extension/payment/kashier_card');
        $this->load->model('extension/payment/kashier_card');
        $data['text_testmode'] = $this->language->get('text_testmode');
        $data['testmode'] = $this->config->get('payment_kashier_card_test');
        if ($this->config->get('payment_kashier_card_test')) {
            $data['mode'] = 'test';
            $secret = $this->config->get('payment_kashier_card_testapikey');
        } else {
            $data['mode'] = 'live';
            $secret= $this->config->get('payment_kashier_card_liveapikey');
        }
        $this->load->model('checkout/order');
        $order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);
        if ($order_info) {

            $metaData = array(
                'Customer Order Id' => $this->session->data['order_id'],
                'Customer Telephone' => $order_info['telephone'],
                'Customer Email' => $order_info['email'],
                'Custome Name' => $order_info['payment_firstname'] . ' ' . $order_info['payment_lastname'],
                'ecommercePlatform' => 'openCart',
            );

            $data['item_name'] = html_entity_decode($this->config->get('config_name'), ENT_QUOTES, 'UTF-8');
            
            $total = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value'], false);
            
            $data['currency_code'] = $order_info['currency_code'];
            $data['metaData']= json_encode($metaData);
            $data['address1'] = $order_info['payment_address_1'];
            $data['address2'] = $order_info['payment_address_2'];
            $data['city'] = $order_info['payment_city'];
            $data['zip'] = $order_info['payment_postcode'];
            $data['country'] = $order_info['payment_iso_code_2'];
            $data['email'] = $order_info['email'];
            $data['invoice'] = $this->session->data['order_id'] . ' - ' . $order_info['payment_firstname'] . ' ' . $order_info['payment_lastname'];
            $data['lc'] = ($this->session->data['language'] === 'ar') || ($this->session->data['language'] === 'eg-ar') ? 'ar' : 'en';
            $data['notify_url'] = urlencode($this->url->link('extension/payment/kashier_card/callback', '', true));
            $data['redirectMethod'] = 'get';
            $data['mid'] = $this->config->get('payment_kashier_card_mid');
            $data['amount'] = $total;
            $data['orderId'] = $this->session->data['order_id'] . '_' . time();
            $data['storeName'] = $this->config->get('config_name');
            $data['hash'] = $this->model_extension_payment_kashier_card->generateKashierOrderHash(array(
                'currency' => $data['currency_code'],
                'amount' => $total,
                'mid' => $data['mid'],
                'secret' => $secret,
                'merchantOrderId' => $data['orderId'],
            ));

            $data['method'] = 'card';
            
            return $this->load->view('extension/payment/kashier_gateway', $data);
        }
    }

    public function callback()
    {
        $this->load->language('extension/payment/kashier_card');
        $this->load->model('extension/payment/kashier_card');

        if ($this->config->get('payment_kashier_card_test')) {
            $secret = $this->config->get('payment_kashier_card_testapikey');
        } else {
            $secret= $this->config->get('payment_kashier_card_liveapikey');
        }

        $this->load->model('checkout/order');

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
         
            echo'received';

            $json_data = json_decode(file_get_contents('php://input'), true);
            $data_obj = $json_data['data'];
            $event = $json_data['event'];

            $headers = getallheaders();
            // Lower case all keys
            $headers = array_change_key_case($headers);
            $data = [];
        
            foreach ($data_obj['signatureKeys'] as $key) {
                $data[$key] = $data_obj[$key];
            }

            $queryString = http_build_query($data, $numeric_prefix = "", $arg_separator = '&', $encoding_type = PHP_QUERY_RFC3986);

            $signature = $this->model_extension_payment_kashier_card->validateSignature($queryString, $secret);

            $kashierSignature = $headers['x-kashier-signature'];


            if (isset($data_obj['merchantOrderId'])) {
                $order_id = substr($data_obj['merchantOrderId'], 0, -11);
            } else {
                $order_id = 0;
            }

            $order_info = $this->model_checkout_order->getOrder($order_id);

            if( $order_info){
                if( $signature === $kashierSignature){ 
                    if($event === 'pay'){
                        if(strtoupper($data_obj['status']) === 'SUCCESS') {
                            $order_status_id = $this->config->get('payment_kashier_card_processed_status_id');
                            foreach ($this->model_extension_payment_kashier_card->getOrderHistories($order_id, 0, 100) as $history) {
                                if ($history['order_status_id'] === $order_status_id) {
                                    die("Order already updated: $order_id");
                                }
                            }
                            $comment = sprintf($this->language->get('text_transaction_id'), $data_obj['transactionId']) .'<br/>'. sprintf($this->language->get('text_merchant_id'), $data_obj['merchantOrderId']);
                            $this->model_extension_payment_kashier_card->addOrderHistory($order_id, $order_status_id , $comment);
                        } else {
                            $order_status_id = $this->config->get('payment_kashier_card_failed_status_id');
                            $this->model_extension_payment_kashier_card->addOrderHistory($order_id, $order_status_id );
                        } 
                    } else if($event === 'refund'){
                        if(strtoupper($data_obj['status']) === 'SUCCESS') {
                            $comment = sprintf($this->language->get('text_transaction_id'), $data_obj['transactionId']) .'<br/>'. sprintf($this->language->get('text_merchant_id'), $data_obj['merchantOrderId']);
                            $order_status_id = $this->config->get('payment_kashier_card_refunded_status_id');
                            $this->model_extension_payment_kashier_card->addOrderHistory($order_id, $order_status_id , $comment);
                        } 
                    }
                } else {
                   die('HMAC Failed to validate.');
                }
            } else {
                die('Order Doesn\'t exist');
            }
            
        } elseif ($_SERVER['REQUEST_METHOD'] === 'GET') {
                $obj  = $_REQUEST;
                $data = $_GET;
                $data['payment_status'] = (!empty($this->request->get['paymentStatus']))? $this->request->get['paymentStatus'] : 'FAILURE';

                if (isset($this->request->get['merchantOrderId'])) {
                    $order_id = substr($this->request->get['merchantOrderId'], 0, -11);
                } else {
                    $order_id = 0;
                }
        
                $order_info = $this->model_checkout_order->getOrder($order_id);
                if ($order_info) {
                    
                    if (isset($this->request->get['paymentStatus'])) {
                        
                      if($this->request->get['paymentStatus'] === 'SUCCESS') {
                          $this->model_extension_payment_kashier_card->preRedirect($data);
                      } else {
                         $data['payment_status'] = 'FAILURE';
                         $this->model_extension_payment_kashier_card->preRedirect($data);
                     } 
                    }
                        
                 } else {
                    $this->session->data['error'] = $this->language->get('error_invalid_order');
                    $this->model_extension_payment_kashier_card->preRedirect($data);  
                }
        } else {
                die('METHOD "' . $_SERVER['REQUEST_METHOD'] . '" NOT ALLOWED');
        }
        
     }
    
}