<?php
trait KashierModel{

    public function addOrderHistory($order_id, $order_status_id, $comment = ''){
		try{
			$this->model_checkout_order->addOrderHistory($order_id, $order_status_id, $comment);
		} catch(\Exception $e){
		}
	}

    public function getOrderHistories($order_id, $start = 0, $limit = 10)
    {
        if ($start < 0) {
            $start = 0;
        }

        if ($limit < 1) {
            $limit = 10;
        }

        $query = $this->db->query("SELECT oh.date_added, oh.order_status_id, os.name AS status, oh.comment, oh.notify FROM " . DB_PREFIX . "order_history oh LEFT JOIN " . DB_PREFIX . "order_status os ON oh.order_status_id = os.order_status_id WHERE oh.order_id = '" . (int) $order_id . "' AND os.language_id = '" . (int) $this->config->get('config_language_id') . "' ORDER BY oh.date_added DESC LIMIT " . (int) $start . "," . (int) $limit);

        return $query->rows;
    }

	public function generateKashierOrderHash($order)
	{

		$mid = $order['mid']; 

		$amount = $order['amount']; 

		$currency = $order['currency']; 

		$orderId = $order['merchantOrderId'];

		$secret = $order['secret'];

		$path = "/?payment=".$mid.".".$orderId.".".$amount.".".$currency;
		return hash_hmac( 'sha256' , $path , $secret ,false);
	}
    
	/**
	* show template while response 
	*/
	public function preRedirect($data){
        
		$data['continue'] = $this->url->link('checkout/cart');
		if(!empty($data['payment_status'])){
            if ($data['payment_status'] == 'SUCCESS') {
                $data['success'] = true;
                
                $this->load->language('checkout/success');
    
                if (isset($this->session->data['order_id'])) {
                    $this->cart->clear();
    
                    unset($this->session->data['shipping_method']);
                    unset($this->session->data['shipping_methods']);
                    unset($this->session->data['payment_method']);
                    unset($this->session->data['payment_methods']);
                    unset($this->session->data['guest']);
                    unset($this->session->data['comment']);
                    unset($this->session->data['order_id']);
                    unset($this->session->data['coupon']);
                    unset($this->session->data['reward']);
                    unset($this->session->data['voucher']);
                    unset($this->session->data['vouchers']);
                    unset($this->session->data['totals']);
                }
    
                $this->document->setTitle($this->language->get('heading_title'));
                $data['text_success'] = $this->language->get('text_success');

                $data['breadcrumbs'] = [];
    
                $data['breadcrumbs'][] = [
                    'text' => $this->language->get('text_home'),
                    'href' => $this->url->link('common/home'),
                ];
    
                $data['breadcrumbs'][] = [
                    'text' => $this->language->get('text_basket'),
                    'href' => $this->url->link('checkout/cart'),
                ];
    
                $data['breadcrumbs'][] = [
                    'text' => $this->language->get('text_checkout'),
                    'href' => $this->url->link('checkout/checkout', '', true),
                ];
    
                $data['breadcrumbs'][] = [
                    'text' => $this->language->get('text_success'),
                    'href' => $this->url->link('checkout/success'),
                ];
    
                $data['continue'] = $this->url->link('common/home');
    
                $data['column_left']    = $this->load->controller('common/column_left');
                $data['column_right']   = $this->load->controller('common/column_right');
                $data['content_top']    = $this->load->controller('common/content_top');
                $data['content_bottom'] = $this->load->controller('common/content_bottom');
                $data['footer']         = $this->load->controller('common/footer');
                $data['header']         = $this->load->controller('common/header');
    
                $this->response->setOutput($this->load->view('extension/payment/kashier_gateway_response', $data));
            }        
            
           if ($data['payment_status'] == 'FAILURE') {
                $data['error'] = true;
    
                $this->load->language('checkout/failure');
    
                $this->document->setTitle($this->language->get('heading_title'));
                $data['text_failure'] = $this->language->get('text_failure');

                $data['breadcrumbs'] = [];
    
                $data['breadcrumbs'][] = [
                    'text' => $this->language->get('text_home'),
                    'href' => $this->url->link('common/home'),
                ];
    
                $data['breadcrumbs'][] = [
                    'text' => $this->language->get('text_basket'),
                    'href' => $this->url->link('checkout/cart'),
                ];
    
                $data['breadcrumbs'][] = [
                    'text' => $this->language->get('text_checkout'),
                    'href' => $this->url->link('checkout/checkout', '', true),
                ];
    
                $data['breadcrumbs'][] = [
                    'text' => $this->language->get('text_failure'),
                    'href' => $this->url->link('checkout/failure'),
                ];
    
                $data['text_message'] = sprintf($this->language->get('text_message'), $this->url->link('information/contact'));
    
                $data['continue'] = $this->url->link('common/home');
    
                $data['column_left']    = $this->load->controller('common/column_left');
                $data['column_right']   = $this->load->controller('common/column_right');
                $data['content_top']    = $this->load->controller('common/content_top');
                $data['content_bottom'] = $this->load->controller('common/content_bottom');
                $data['footer']         = $this->load->controller('common/footer');
                $data['header']         = $this->load->controller('common/header');
    
                $this->response->setOutput($this->load->view('extension/payment/kashier_gateway_response', $data));
            }
    
		}
        return $this->response->getOutput();
	}

    public function validateSignature($payload, $secret)
    {
        return hash_hmac('sha256',$payload, $secret, false);
    }
}