<?php
if (!trait_exists('KashierModel', false)) {
    include_once 'Kashier/KashierModel.php';
}

class ModelExtensionPaymentKashierInstallment extends Model {

    use KashierModel;


    public function getMethod($address, $total) {
        $this->load->language('extension/payment/kashier_installment');

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$this->config->get('payment_kashier_installment_geo_zone_id') . "' AND country_id = '" . (int)$address['country_id'] . "' AND (zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')");

        if ($this->config->get('payment_kashier_installment_total') > $total) {
            $status = false;
        } elseif (!$this->config->get('payment_kashier_installment_geo_zone_id')) {
            $status = true;
        } elseif ($query->num_rows) {
            $status = true;
        } else {
            $status = false;
        }

        $currencies = array(
            'EUR',
            'EGP',
            'GBP',
            'USD',
        );

        if (!in_array(strtoupper($this->session->data['currency']), $currencies)) {
            $status = false;
        }

        $method_data = array();

        if ($status) {
            $method_data = array(
                'code'       => 'kashier_installment',
                'title'      => $this->language->get('text_title'),
                'terms'      => '',
                'sort_order' => $this->config->get('payment_kashier_installment_sort_order')
            );
        }

        return $method_data;
    }

}