<?php
class ModelToolSeoPackage extends Model {
 
  public function hrefLang($linkRoute = false, $linkUrl = '') {
    if (!$this->config->get('mlseo_hreflang')) {
      return;
    }
    
    $this->load->model('localisation/language');
    $langs = $this->model_localisation_language->getLanguages();
    
    // save current language values
    $current_config_lang = $this->config->get('config_language');
    $current_lang_id = $this->config->get('config_language_id');
    $current_lang_code = isset($this->session->data['language']) ? $this->session->data['language'] : '';
    
    if (!$linkRoute) {
      // construct url
      $data = $this->request->get;
      
      // do not display hreflang if page or limit parameter
      if (!empty($data['route']) && $data['route'] == 'product/category' && count($data) !== 3) {
        //return; // disabled, seems now necessary by google
      }
      
      unset($data['_route_']);
      unset($data['site_language']);
      unset(/*$data['page'],*/ $data['limit'], $data['order'], $data['sort']);
      
      if (isset($data['route']) && $data['route']) {
        $route = $data['route'];
      } else {
        $route = 'common/home';
      }
      
      unset($data['route']);

      $url = '';
      
      // remove all extra data for product page
      if ($route == 'product/product' && isset($data['product_id'])) {
        $data = array('product_id' => $data['product_id']);
      }
      
      if (isset($data['path'])) {
        if (empty($data['product_id'])) {
          $url .= 'path=' . $data['path'] . '&';
        }
        
        unset($data['path']);
      }
      
      if (isset($data['language'])) {
        unset($data['language']);
      }
      
      if ($data) {
        $data = array_reverse($data);
        $url .=  urldecode(http_build_query($data, '', '&'));
      }
    } else {
      $route = $linkRoute;
      $url = $linkUrl;
    }
    
    // not possible to get correct data so do not include hreflang for journal
    if (isset($route) && in_array($route, array('journal3/blog', 'journal3/blog/category', 'journal3/blog/post'))) {
      return;
    }
    
    $hreflangs = array();
    
    // handle sub-stores rewriting
    if ($this->config->get('mlseo_store_mode')) {
      $lang_to_store = $this->config->get('mlseo_lang_to_store');
    }
    
    // generate hreflangs
    foreach ($langs as $lang) {
      // set language to get each link
      $this->config->set('config_language', $lang['code']);
      $this->config->set('config_language_id', $lang['language_id']);
      $this->session->data['language'] = $lang['code'];
      
      $addLanguage = '';
      
      if (version_compare(VERSION, '4', '>=')) {
        $addLanguage = $url ? '&language='.$lang['code'] : 'language='.$lang['code'];
      }
      
      if (!empty($lang_to_store[$lang['code']])) {
        $hreflangs[] = array(
          'href' => !empty($lang_to_store) ? str_replace(array(rtrim($this->config->get('config_url'),'/'), rtrim($this->config->get('config_ssl'),'/')), array_map(array('self','trimSlash'), $lang_to_store[$lang['code']]), $this->url->link($route, $url.$addLanguage)) : $this->url->link($route, $url.$addLanguage),
          'hreflang' => (!$this->config->get('mlseo_hreflang_mode') ? substr($lang['code'], 0, 2) : $lang['code'])
        );
        
        if ($this->config->get('mlseo_hreflang_xdefault')) {
          if ($this->config->get('mlseo_default_lang') == $lang['code']) {
            $hreflangs[] = array(
              'href' => !empty($lang_to_store) ? str_replace(array(rtrim($this->config->get('config_url'),'/'), rtrim($this->config->get('config_ssl'),'/')), array_map(array('self','trimSlash'), $lang_to_store[$lang['code']]), $this->url->link($route, $url.$addLanguage)) : $this->url->link($route, $url.$addLanguage),
              'hreflang' => 'x-default'
            );
          }
        }
      } else {
        $hreflangs[] = array(
          'href' => $this->url->link($route, $url.$addLanguage),
          'hreflang' => (!$this->config->get('mlseo_hreflang_mode') ? substr($lang['code'], 0, 2) : $lang['code'])
        );
        
        if ($this->config->get('mlseo_hreflang_xdefault')) {
          if ($this->config->get('mlseo_default_lang') == $lang['code']) {
            $hreflangs[] = array(
              'href' => $this->url->link($route, $url.$addLanguage),
              'hreflang' => 'x-default'
            );
          }
        }
      }
    }
    
    if (!$this->config->get('mlseo_hreflang_xdefault')) {
      if (!empty($lang_to_store) && $route == 'common/home') {
        $hreflangs[] = array(
          'href' => $this->config->get('config_url'),
          'hreflang' => 'x-default'
        );
      }
    }
    
    /*
    if (!empty($lang_to_store) && $route == 'common/home') {
      $hreflangs[] = array(
        'href' => str_replace(array(rtrim($this->config->get('config_url'),'/'), rtrim($this->config->get('config_ssl'),'/')), array_map(array('self','trimSlash'), array('config_url' => HTTP_SERVER, 'config_ssl' => HTTPS_SERVER)), str_replace('/'.$lang['code'].'/', '/', $this->url->link($route, $url))),
        'hreflang' => 'x-default'
      );
    }
    */
    
    // if ($route == 'common/home' && !$this->config->get('mlseo_flag_mode')) {
      // $hreflangs = array();
    // }
    
    // restore current language values
    $this->config->set('config_language', $current_config_lang);
    $this->config->set('config_language_id', $current_lang_id);
    $this->session->data['language'] = $current_lang_code;

    if ($linkRoute) {
      return $hreflangs;
    }
    $output =  '';
    
    foreach ($hreflangs as $link) {
      $output .=  '<link rel="alternate" href="'.$link['href'].'" hreflang="'.$link['hreflang'].'"/>'."\n";
    }
    
    $this->document->addSeoMeta($output);
    //return $hreflangs;
  }
  
  private static function trimSlash($val) {
    return rtrim($val, '/');
  }
  
  public function metaRobots() {
    if (!$this->config->get('mlseo_robots')) {
      return;
    }
    
    // do not display if already defined
    if (strpos($this->document->renderSeoMeta(), '<meta name="robots"') !== false) {
      return;
    }
    
    $page = !empty($this->request->get['route']) ? $this->request->get['route'] : 'common/home';
    $page = str_replace(array('common/home', 'product/product', 'product/category', 'information/information', 'information/contact', 'product/search', 'product/manufacturer/info'),
                        array('home', 'product', 'category', 'information', 'contact', 'search', 'manufacturer'), $page);
    
    if ($page == 'search' && !empty($this->request->get['tag'])) {
      $page = 'tag';
    }
    
    if (strstr($page, '/', true)) {
      $page = strstr($page, '/', true);
    }
    
    // set default robots value
    $robots = $this->config->get('mlseo_meta_robots');
    $value = isset($robots[$page]) ? $robots[$page] : '';
    $getParams = $this->request->get;
    
    if (isset($getParams['ignorenitro'])) {
      unset($getParams['ignorenitro']);
    }
    
    if ($page == 'error') {
      $value = 'none';
    } else if ($page == 'search') {
      if (empty($this->request->get['tag']) || isset($this->request->get['page']) || isset($this->request->get['limit']) || isset($this->request->get['sort'])) {
        $value = 'none';
      }
    } elseif ((!empty($this->request->get['page']) && $this->request->get['page'] !== '1')) {
      $value = isset($robots['page']) ? $robots['page'] : '';
    } elseif (!empty($this->request->get['limit']) || !empty($this->request->get['sort'])) {
      $value = 'noindex';
    }
    
    // override pagination setting
    if (($page == 'category' && isset($this->request->get['page']) && count($getParams) > 4) || ($page == 'category' && !isset($this->request->get['page']) && count($getParams) > 3) || ($page == 'product' && count($getParams) > 4)) {
      // no index if any extra parameter in category
      $value = isset($robots['catfilters']) ? $robots['catfilters'] : 'noindex';
    }
    
    // disabled routes
    if (!empty($this->request->get['route']) && in_array($this->request->get['route'], array('extension/cireviewpro/cireviews'))) {
      return;
    }
    
    if ($value == 'none' || $value == 'noindex') {
      $sitemapConfig = $this->config->get('advanced_sitemap_cfg');
      
      if (!empty($sitemapConfig['custom_links_include'])) {
        $custom_links_include = explode("\n", $sitemapConfig['custom_links_include']);
        foreach ($custom_links_include as $k => $v) {
          if (strpos($v, '@')) {
            list($custType, $custUrl) = explode('@',$v, 2);
          } else {
            $custUrl = $v;
          }
          
          if ((empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]" == trim($custUrl)) {
            $value = '';
          }
        }
      }
    }
    
    if (!$value) {
      return;
    }
    
    $output = '<meta name="robots" content="'.$value.'"/>'."\n";
    
    $this->document->addSeoMeta($output);
  }
  
  public function richSnippets() {
    $page = !empty($this->request->get['route']) ? $this->request->get['route'] : 'common/home';
    $page = str_replace(array('common/home', 'product/product', 'product/category', 'information/information', 'information/contact'),
                        array('home', 'product', 'category', 'information', 'contact'), $page);
    $metas = '';
    
    switch ($page) {
      case 'home': $types = array('gpublisher', 'microdata', 'opengraph', 'tcard'); break;
      case 'category': $types = array('opengraph'); break;
      //case 'product': $types = array('microdata', 'opengraph', 'tcard'); break;
      default: $types = array(); break;
    }
    
    foreach ($types as $type) {
      if (!$this->config->get('mlseo_'.$type)) continue;
      
      $metas .= $this->rich_snippet($type, $page);
    }
    
    if ($this->config->get('mlseo_fb_pixel')) {
      $metas .= html_entity_decode($this->config->get('mlseo_fb_pixel'), ENT_QUOTES, 'UTF-8');
    }
    
    $this->document->addSeoMeta($metas);
  }
  
  public function rich_snippet($type, $page, $data = array()) {
    $j3SeoEngine = false;
    
    $config = $data['config'] = $this->config->get('mlseo_'.$type.'_data');
    
    if ($page == 'home' && $type == 'gpublisher') {
      $data['url'] = $config['url'];
    } else if ($page == 'product') {
      // currency
      if (isset($this->session->data['currency'])) {
        $data['currency'] = $this->session->data['currency'];
      } else {
        $data['currency'] = $this->currency->getCode();
      }
      
      // get unformatted price
      if (!$this->config->get('config_customer_price') && !empty($data['product_info']['price'])) {
        $data['price'] = $this->currency->format($this->tax->calculate($data['product_info']['price'], $data['product_info']['tax_class_id'], $this->config->get('config_tax')), $data['currency'], 0, false);
        
        if ($data['special']) {
          $data['special'] = $this->currency->format($this->tax->calculate($data['product_info']['special'], $data['product_info']['tax_class_id'], $this->config->get('config_tax')),$data['currency'], 0, false);
        }
      }
      
      // category
      $category = array();
      
      foreach ($data['breadcrumbs'] as $breadcrumb) {
        if (strip_tags($breadcrumb['text'])) {
          $category[] = strip_tags($breadcrumb['text']);
        }
      }
      
      if (!empty($data['product_info']['product_id'])) {
        $data['product_url'] = $this->url->link('product/product', 'product_id='.$data['product_info']['product_id']);
      }
      
      if ($type == 'opengraph') {
        $images = $this->model_catalog_product->getProductImages($data['product_info']['product_id']);
        
        $data['squareImages'] = array();
        
        foreach ($images as $img) {
          $data['squareImages'][] = $this->model_tool_image->resize($img['image'], 1024, 1024);
        }
        
        $data['thumb'] = $this->model_tool_image->resize($data['product_info']['image'], 1024, 1024);
      }
      
      $data['category'] = implode(' &raquo; ', $category);
      
      if ($data['category'] == $data['heading_title'] || (isset($data['product_info']['name']) && $data['category'] == $data['product_info']['name'])) {
        $data['category'] = '';
      }
    
      // reviews
      $data['reviews'] = array();
      
      if (!empty($config['reviews']) && in_array($type, array('microdata', 'opengraph')) && !empty($data['product_id'])) {
        $this->load->model('catalog/review');
        $data['reviews'] = $this->model_catalog_review->getReviewsByProductId($data['product_id']);
      }
      
      $data['microdata_desc'] = $this->config->get('mlseo_microdata_desc');
    } else if ($page == 'home') {
      $seo_meta = $this->config->get('mlseo_store');
      if (isset($seo_meta[$this->config->get('config_store_id').$this->config->get('config_language_id')])) {
        $seo_meta = $seo_meta[$this->config->get('config_store_id').$this->config->get('config_language_id')];
      }
      
      $data['url'] = $this->url->link('common/home');
      
      $this->load->model('tool/image');
      
      $logo = $this->config->get('config_logo');
      $data['logo'] = '';
      
      
      if (is_array($logo) && isset($logo[$this->config->get('config_language_id')]) && is_file(DIR_IMAGE . $logo[$this->config->get('config_language_id')])) {
        // compatibility with multilingual logo extensions
        $data['logo'] = $this->model_tool_image->resize($logo[$this->config->get('config_language_id')], 300, 300); // 300x300 for fb
      } else if (is_string($logo) && is_file(DIR_IMAGE . $logo)) {
        $data['logo'] = $this->model_tool_image->resize($logo, 300, 300); // 300x300 for fb
      } else if ($this->config->get('config_image') && is_file(DIR_IMAGE . $this->config->get('config_image'))) {
        $data['logo'] = $this->model_tool_image->resize($this->config->get('config_image'), 300, 300); // 300x300 for fb
      }
      
      /*
      if (is_file(DIR_IMAGE . $this->config->get('config_logo'))) {
        $data['logo'] = $this->config->get('config_url') . 'image/' . $this->config->get('config_logo');
      } else {
        $data['logo'] = '';
      }
      */
      
      if (!empty($seo_meta['seo_title'])) {
        $data['title'] = $seo_meta['seo_title'];
      } else if ($this->config->get('config_meta_title')) {
        $data['title'] = $this->config->get('config_meta_title');
      } else {
        $data['title'] = $this->config->get('config_title');
      }
      
      if (!empty($seo_meta['description'])) {
        $data['desc'] = $seo_meta['description'];
      } else {
        $data['desc'] = $this->config->get('config_meta_description');
      }
    } else if ($page == 'category' && !empty($this->request->get['path'])) {
      $this->load->model('catalog/category');
      $path = $this->request->get['path'];
      $category_ids = explode('_', $path);
      $category_id = end($category_ids);
      $category_info = $this->model_catalog_category->getCategory($category_id);
      
      if (!empty($category_info)) {
        $data['title'] = $category_info['name'];
        $this->load->model('tool/image');
        $data['image'] = $this->model_tool_image->resize($category_info['image'], 300, 300);
        if (!empty($category_info['meta_description'])) {
          $data['description'] = strip_tags(html_entity_decode($category_info['meta_description'], ENT_QUOTES, 'UTF-8'));
        } else {
          $data['description'] = substr(strip_tags(html_entity_decode($category_info['description'], ENT_QUOTES, 'UTF-8')), 0, 300); 
        }
        $data['url'] = $this->url->link('product/category','path='.$path, true);
      } else {
        $data['title'] = '';
        $data['image'] = '';
        $data['description'] = '';
        $data['url'] = '';
      }
      
    } else if ($page == 'info') {
      if (!empty($this->request->get['information_id'])) {
        $information_id = (int)$this->request->get['information_id'];
      } else {
        $information_id = 0;
      }
      
      $data['url'] = $this->url->link('information/information', 'information_id='.$information_id);
    } else if ($page == 'journal3/blog/post') {
      if (!empty($data['post_id'])) {
        if ($j3SeoEngine) { //always enabled because isset is not working
          //$data['url'] = $this->journal3_url->link('journal3/blog/post', 'journal_blog_post_id=' . $data['post_id']);
        } else {
          //$data['url'] = $this->url->link('journal3/blog/post', 'journal_blog_post_id=' . $data['post_id']);
        }
      }
    }
    
    // display
    $data['config_name'] = $this->config->get('config_name');
    $data['type'] = $type;
    $data['page'] = $page;
    
    if ($type == 'microdata') {
      return $this->microdataJson($page, $data);
    }
    
    if (version_compare(VERSION, '4', '>=')) {
      $tpl = new \Opencart\System\Library\Template('template');
      $tpl->addPath('extension/complete_seo', DIR_EXTENSION . 'complete_seo/catalog/view/template/');
      return $tpl->render('extension/complete_seo/module/seopackage_rich_snippet', $data);
    } else if (version_compare(VERSION, '3', '>=')) {
      $template = new Template('template', $this->registry);
      foreach ($data as $key => $value) {
        $template->set($key, $value);
      }
      
      $rf = new ReflectionMethod('Template', 'render');
      
      if ($rf->getNumberOfParameters() > 2) {
        return $template->render('default/template/module/seopackage_rich_snippet', $this->registry, false);
      } else {
        return $template->render('default/template/module/seopackage_rich_snippet', false);
      }
      
      return $template->render('default/template/module/seopackage_rich_snippet');
    } else if (version_compare(VERSION, '2.2', '>=')) {
      $template = new Template(version_compare(VERSION, '2.3', '>=') ? 'php': 'basic');
      foreach ($data as $key => $value) {
        $template->set($key, $value);
      }
      return $template->render('default/template/module/seopackage_rich_snippet.tpl', null); // null is for compatibility with fastor theme
    } elseif (method_exists($this->load, 'view')) {
      return $this->load->view('default/template/module/seopackage_rich_snippet.tpl', $data);
    } else {
      $template = new Template();
      $template->data = &$data;
      return $template->fetch('default/template/module/seopackage_rich_snippet.tpl');
    }
  }
  
  public function getSeoDescription($type, $item_id) {
    $store_id = $this->config->get('mlseo_multistore') ? $this->config->get('config_store_id') : 0;
    
    $seoTable = 'seo_';
    $whereStore = "AND store_id = '".(int) $store_id."'";
    
    if (!$store_id && $type != 'manufacturer') {
      $seoTable = '';
      $whereStore = '';
    }
    
    $query = $this->db->query("SELECT * FROM " . DB_PREFIX . $seoTable.$type."_description d WHERE ".$this->db->escape($type)."_id = '" . (int)$item_id . "' AND language_id = '".(int) $this->config->get('config_language_id')."'".$whereStore)->row;
		
    if (!empty($query['description'])) {
      if (defined('HTTPS_SERVER')) {
        $query['description'] = str_replace(array(HTTP_SERVER, HTTPS_SERVER), array($this->config->get('config_url'), $this->config->get('config_ssl')), $query['description']);
      } else {
        $query['description'] = $query['description'];
      }
    }
		
    return $query;
	}
  
  public function microdataJson($page, $data) {
    $config = !empty($data['config']) ? $data['config'] : '';
    $output = '';
    
    if (empty($data['url'])) {
      if (!empty($this->request->server['HTTPS'])) {
        $data['url'] = $this->config->get('config_ssl');
      } else {
        $data['url'] = $this->config->get('config_url');
      }
    }
    
    if (empty($data['currency'])) {
      if (isset($this->session->data['currency'])) {
          $data['currency'] = $this->session->data['currency'];
      } else {
        $data['currency'] = $this->currency->getCode();
      }
    }
    
    if (empty($data['logo'])) {
      //$data['logo'] = $data['url'] . 'image/' . $this->config->get('config_logo');
      $this->load->model('tool/image');
      
      $logo = $this->config->get('config_logo');
      $data['logo'] = '';
      
      if (is_array($logo) && isset($logo[$this->config->get('config_language_id')]) && is_file(DIR_IMAGE . $logo[$this->config->get('config_language_id')])) {
        // compatibility with multilingual logo extensions
        $data['logo'] = $this->model_tool_image->resize($logo[$this->config->get('config_language_id')], 300, 300); // 300x300 for fb
      } else if (is_string($logo) && is_file(DIR_IMAGE . $logo)) {
        $data['logo'] = $this->model_tool_image->resize($logo, 300, 300); // 300x300 for fb
      } else if ($this->config->get('config_image') && is_file(DIR_IMAGE . $this->config->get('config_image'))) {
        $data['logo'] = $this->model_tool_image->resize($this->config->get('config_image'), 300, 300); // 300x300 for fb
      }
    }
    
    // Breadcrumbs
    if (in_array($page, array('product', 'category', 'manufacturer', 'information', 'contact')) && !empty($config['breadcrumbs'])) {
      $json = array();
      $json['@context'] = 'http://schema.org';
      $json['@type'] = 'BreadcrumbList';
      
      if (!empty($data['breadcrumbs'])) {
        $pos = 1;
        foreach ($data['breadcrumbs'] as $breadcrumb) {
          $breadcrumbName = trim(strip_tags($breadcrumb['text'])) ? html_entity_decode(strip_tags($breadcrumb['text']), ENT_QUOTES, 'UTF-8') : html_entity_decode($data['config_name'], ENT_QUOTES, 'UTF-8');
          
          if (trim($breadcrumbName)) {
            $json['itemListElement'][] = array(
              '@type' => 'ListItem',
              'position' => $pos++,
              'item' => array(
                '@id' => urldecode($breadcrumb['href']),
                'name' => $breadcrumbName,
              ),
            );
          }
        }
      }
      
      $output .= '<script type="application/ld+json">'.json_encode($json).'</script>'."\n";
    }
    
    // Category
    if ($page == 'category' && !empty($config['category'])) {
      $includeItemList = false; // moved into controller/product/category to make it to be cached by journal
      
      if (isset($this->request->get['path'])) {
        $parts = explode('_', (string)$this->request->get['path']);

        $category_id = (int)array_pop($parts);
        
        $filter_data = array(
          'filter_category_id' => $category_id,
          'filter_sub_category' => !empty($config['sub_categories']),
        );

        $product_total = $this->model_catalog_product->getTotalProducts($filter_data);

        $products = $this->model_catalog_product->getProducts($filter_data);
        
        $best_rating = $review_total = 0;
        
        $itemListElement = array();
        
        $i = 0;
        
        foreach ($products as $product) {
          $review_total += $product['rating'];
          $best_rating = ($product['rating'] > $best_rating) ? $product['rating'] : $best_rating;
          /*
          foreach ($data['reviews'] as $review) {
            $json['review'][] = array(
              '@type' => 'Review',
              'name' => !empty($data['product_info']['meta_title']) ? html_entity_decode($data['product_info']['meta_title'], ENT_QUOTES, 'UTF-8') : html_entity_decode($data['heading_title'], ENT_QUOTES, 'UTF-8'),
              'itemReviewed' => !empty($data['product_info']['meta_title']) ? html_entity_decode($data['product_info']['meta_title'], ENT_QUOTES, 'UTF-8') : html_entity_decode($data['heading_title'], ENT_QUOTES, 'UTF-8'),
              'author' => array(
                '@type' => 'Person',
                'name' => '',
              ),
              'reviewBody' => $review['text'],
              'datePublished' => date('Y-m-d', strtotime($review['date_added'])),
              'reviewRating' => array(
                '@type' => 'Rating',
                'ratingValue' => $review['rating'],
              ),
            );
              
            $review_total += $review['rating'];
            $best_rating = ($review['rating'] > $best_rating) ? $review['rating'] : $best_rating;
          }
          */
          
          if ($includeItemList && $i <= 20) {
            $currentItem = array();
            $currentItem['@context'] = 'http://schema.org';
            $currentItem['@type'] = 'Product';
            $currentItem['url'] = $this->url->link('product/product', 'product_id='.$product['product_id']);
            $currentItem['name'] = !empty($product['meta_title']) ? html_entity_decode($product['meta_title'], ENT_QUOTES, 'UTF-8') : html_entity_decode($product['name'], ENT_QUOTES, 'UTF-8');
            $currentItem['image'] = $this->model_tool_image->resize($product['image'], 1024, 1024);
            
            $has_idtentifier = false;
            
            if (!empty($config['model'])) {
              $currentItem['model'] = $product['model'];
            }
            
            if (!empty($config['mpn']) && !empty($product['mpn'])) {
              $currentItem['mpn'] = $product['mpn'];
              $has_idtentifier = true;
            }
            
            if (!empty($config['sku'])) {
              $currentItem['sku'] = !empty($product['sku']) ? $product['sku'] : $product['model'];
            }
            
            if (!empty($config['upc']) && !empty($data['product_info']['upc'])) {
              $currentItem['gtin12'] = $product['upc'];
              $currentItem['gtin'] = $dproduct['upc'];
              $has_idtentifier = true;
            } else if (!empty($config['ean']) && !empty($product['ean'])) {
              $currentItem['gtin'] = $product['ean'];
              $currentItem['gtin8'] = $product['ean'];
              $has_idtentifier = true;
            } else if (!empty($config['jan']) && !empty($product['jan'])) {
              $currentItem['gtin'] = $product['jan'];
              $has_idtentifier = true;
            } else if (!empty($config['isbn']) && !empty($product['isbn'])) {
              //$currentItem['gtin13'] = $data['product_info']['isbn'];
              $currentItem['gtin'] = $product['isbn'];
              $currentItem['isbn'] = $product['isbn'];
              $has_idtentifier = true;
            }
            
            if (!empty($config['brand']) && !empty($product['manufacturer'])) {
              $currentItem['manufacturer'] = strip_tags($product['manufacturer']);
              $currentItem['brand'] = array(
                  '@type' => 'Brand',
                  'name' => strip_tags($product['manufacturer']),
                );
            }
            
            if ($product['special']) {
              $specialQuery = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_special ps WHERE ps.product_id = " . (int)$product['product_id'] . " AND ps.customer_group_id = '" . (int)$this->config->get('config_customer_group_id') . "' AND ((ps.date_start = '0000-00-00' OR ps.date_start < NOW()) AND (ps.date_end = '0000-00-00' OR ps.date_end > NOW())) ORDER BY ps.priority ASC, ps.price ASC LIMIT 1")->row;
               
              $currentItem['offers'] = array(
                'name' => !empty($product['meta_title']) ? html_entity_decode($product['meta_title'], ENT_QUOTES, 'UTF-8') : html_entity_decode($product['name'], ENT_QUOTES, 'UTF-8'),
                'url' => $currentItem['url'],
                'price' => $this->config->get('config_customer_price') ? '' : $product['special'],
                'priceCurrency' => $data['currency'],
                'itemCondition' => 'http://schema.org/NewCondition',
                'seller' => array(
                  '@type' => 'Organization',
                  'name' => $data['config_name'],
                ),
              );
              
              if (isset($specialQuery['date_end']) && $specialQuery['date_end'] != '0000-00-00') {
                $currentItem['offers']['priceValidUntil'] = $specialQuery['date_end'];
              } else {
                $currentItem['offers']['priceValidUntil'] = date('Y-m-d', strtotime('+1 years', strtotime(date("Y-m-d "))));
              }
            } else {
              $currentItem['offers'] = array(
                'name' => !empty($product['meta_title']) ? html_entity_decode($product['meta_title'], ENT_QUOTES, 'UTF-8') : html_entity_decode($product['name'], ENT_QUOTES, 'UTF-8'),
                'url' => $currentItem['url'],
                'price' => $this->config->get('config_customer_price') ? '' : $product['price'],
                'priceCurrency' => $data['currency'],
                'priceValidUntil' => date('Y-m-d', strtotime('+1 years', strtotime(date("Y-m-d ")))),
                'itemCondition' => 'http://schema.org/NewCondition',
                'seller' => array(
                  '@type' => 'Organization',
                  'name' => $data['config_name'],
                ),
              );
            }
            
            if ($product['quantity'] > 0) {
              //$currentItem['offers']['availability'] = 'https://schema.org/InStock';
              $currentItem['offers']['availability'] = 'InStock';
            } else {
              $stockStatusQuery = $this->db->query("SELECT stock_status_id FROM " . DB_PREFIX . "product WHERE product_id = " . (int)$product['product_id'])->row;
              
              if (!empty($config['order_status'][$stockStatusQuery['stock_status_id']])) {
                //$currentItem['offers']['availability'] = 'https://schema.org/'.$config['order_status'][$stockStatusQuery['stock_status_id']];
                $currentItem['offers']['availability'] = $config['order_status'][$stockStatusQuery['stock_status_id']];
              }
            }
            
            if (!empty($config['reviews'])) {
              $best_rating = $review_total = 0;
              
              // get all reviews
              if (true) {
                $this->load->model('catalog/review');
                $data['reviews'] = $this->model_catalog_review->getReviewsByProductId($product['product_id'], 0, 999999999999);
              }
              
              foreach ($data['reviews'] as $review) {
                $review_total += $review['rating'];
                $best_rating = ($review['rating'] > $best_rating) ? $review['rating'] : $best_rating;
              }
              
              if (count($data['reviews'])) {
                $currentItem['aggregateRating'] = array(
                  '@type' => 'AggregateRating',
                  'ratingValue' => round($review_total / count($data['reviews']), 1),
                  'bestRating' => $best_rating,
                  'reviewCount' => count($data['reviews']),
                );
              }
            }
            
            $itemListElement[] = $currentItem;
          }
          
          $i++;
        }
        
        if ($product_total > 0) {
          $json = array();
          $json['@context'] = 'http://schema.org';
          $json['@type'] = 'ItemList';
          $json['itemListElement'] = $itemListElement;
          $json['numberOfItems'] = $product_total;
          
          $output .= '<script type="application/ld+json">'.json_encode($json).'</script>'."\n";
        }
        
        if ($product_total > 0 && $review_total > 0) {
          $json = array();
          
          $json['aggregateRating'] = array(
            '@type' => 'AggregateRating',
            'ratingValue' => round($review_total / $product_total, 1),
            'bestRating' => $best_rating,
            'reviewCount' => $product_total,
          );
          
          $output .= '<script type="application/ld+json">'.json_encode($json).'</script>'."\n";
        }
      }
    }
    
    // Product
    if ($page == 'product' && !empty($config['product']) && !empty($data['product_url'])) {
      $json = array();
      $json['@context'] = 'http://schema.org';
      $json['@type'] = 'Product';
      $json['url'] = $data['product_url'];
      $json['name'] = !empty($data['product_info']['meta_title']) ? html_entity_decode($data['product_info']['meta_title'], ENT_QUOTES, 'UTF-8') : html_entity_decode($data['heading_title'], ENT_QUOTES, 'UTF-8');
      
      if (!empty($data['category'])) {
        $json['category'] = html_entity_decode($data['category'], ENT_QUOTES, 'UTF-8');
      }
      
      $json['image'] = $data['thumb'];
      
      if (empty($json['image']) && !empty($data['product_info']['image'])) {
        $json['image'] = $this->model_tool_image->resize($data['product_info']['image'], 1024, 1024);
        
        if (empty($json['image']) && !empty($data['product_info']['image'])) {
          $json['image'] = HTTPS_SERVER.'image/'.$data['product_info']['image'];
        }
      }
      
      $has_idtentifier = false;
      
      if (!empty($config['model'])) {
        $json['model'] = $data['model'];
      }
      
      if (!empty($config['mpn']) && !empty($data['product_info']['mpn'])) {
        $json['mpn'] = $data['product_info']['mpn'];
        $has_idtentifier = true;
      }
      
      if (!empty($config['sku'])) {
        $json['sku'] = !empty($data['product_info']['sku']) ? $data['product_info']['sku'] : $data['model'];
      }
      
      if (!empty($config['upc']) && !empty($data['product_info']['upc'])) {
        $json['gtin12'] = $data['product_info']['upc'];
        $json['gtin'] = $data['product_info']['upc'];
        $has_idtentifier = true;
      } else if (!empty($config['ean']) && !empty($data['product_info']['ean'])) {
        $json['gtin'] = $data['product_info']['ean'];
        $json['gtin8'] = $data['product_info']['ean'];
        $has_idtentifier = true;
      } else if (!empty($config['jan']) && !empty($data['product_info']['jan'])) {
        $json['gtin'] = $data['product_info']['jan'];
        $has_idtentifier = true;
      } else if (!empty($config['isbn']) && !empty($data['product_info']['isbn'])) {
        //$json['gtin13'] = $data['product_info']['isbn'];
        $json['gtin'] = $data['product_info']['isbn'];
        $json['isbn'] = $data['product_info']['isbn'];
        $has_idtentifier = true;
      }
      
      if (!$has_idtentifier) {
        // google doesn't know that... although it is specified in docs
        //$json['identifier_​exists'] = FALSE;
      }
      
      //if (!empty($config['desc'])) {}
      $json['description'] = strip_tags($data['product_info']['meta_description']);
      
      if (!empty($config['brand']) && !empty($data['product_info']['manufacturer'])) {
        $json['manufacturer'] = strip_tags($data['product_info']['manufacturer']);
        $json['brand'] = array(
            '@type' => 'Brand',
            'name' => strip_tags($data['product_info']['manufacturer']),
          );
      }
      
      if ($data['special']) {
        $specialQuery = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_special ps WHERE ps.product_id = " . (int)$data['product_id'] . " AND ps.customer_group_id = '" . (int)$this->config->get('config_customer_group_id') . "' AND ((ps.date_start = '0000-00-00' OR ps.date_start < NOW()) AND (ps.date_end = '0000-00-00' OR ps.date_end > NOW())) ORDER BY ps.priority ASC, ps.price ASC LIMIT 1")->row;
         
        $json['offers'] = array(
          'name' => !empty($data['product_info']['meta_title']) ? html_entity_decode($data['product_info']['meta_title'], ENT_QUOTES, 'UTF-8') : html_entity_decode($data['heading_title'], ENT_QUOTES, 'UTF-8'),
          'url' => $data['product_url'],
          'price' => $this->config->get('config_customer_price') ? '' : $data['special'],
          'priceCurrency' => $data['currency'],
          'itemCondition' => 'http://schema.org/NewCondition',
          'seller' => array(
            '@type' => 'Organization',
            'name' => $data['config_name'],
          ),
        );

        $special_price = $this->config->get('config_customer_price') ? '' : $data['special'];
        
        if (isset($specialQuery['date_end']) && $specialQuery['date_end'] != '0000-00-00') {
          $json['offers']['priceValidUntil'] = $specialQuery['date_end'];
        } else {
          $json['offers']['priceValidUntil'] = date('Y-m-d', strtotime('+1 years', strtotime(date("Y-m-d "))));
        }
      } else {
        $json['offers'] = array(
          'name' => !empty($data['product_info']['meta_title']) ? html_entity_decode($data['product_info']['meta_title'], ENT_QUOTES, 'UTF-8') : html_entity_decode($data['heading_title'], ENT_QUOTES, 'UTF-8'),
          'url' => $data['product_url'],
          'price' => $this->config->get('config_customer_price') ? '' : $data['price'],
          'priceCurrency' => $data['currency'],
          'priceValidUntil' => date('Y-m-d', strtotime('+1 years', strtotime(date("Y-m-d ")))),
          'itemCondition' => 'http://schema.org/NewCondition',
          'seller' => array(
            '@type' => 'Organization',
            'name' => $data['config_name'],
          ),
        );
      }
      
      if (!empty($data['category'])) {
        $json['offers']['category'] = $data['category'];
      }
    
      $price = $this->config->get('config_customer_price') ? '' : $data['price'];
      
      if (!empty($config['shipping']) && !empty($config['shippings'])) {
        foreach ($config['shippings'] as $shipping) {
          $shipping_data = explode(':', $shipping);
          
          if (count($shipping_data) == 5) {
            $weightLimits = array_shift($shipping_data);
            
            if (strpos($weightLimits, '-') === false) {
              error_log('Error: Incorrect rich snippet shipping restriction format, must be formated like 0-500');
            }
            
            if (substr($weightLimits, 0, 1) == 'P') {
              list($lowLimit, $highLimit) = explode('-', str_replace('P', '', $weightLimits));
              
              if (isset($special_price) && $special_price) {
                if ($special_price < $lowLimit || $special_price > $highLimit) {
                  continue;
                }
              } else {
                if ($price < $lowLimit || $price > $highLimit) {
                  continue;
                }
              }
            } else if (substr($weightLimits, 0, 1) == 'S') {
              list($lowLimit, $highLimit) = explode('-', $weightLimits);
              
              if ($realPackSize < $lowLimit || $realPackSize > $highLimit) {
                continue;
              }
            } else if (substr($weightLimits, 0, 1) == 'V') {
              list($lowLimit, $highLimit) = explode('-', $weightLimits);
              
              if ($realPackVolume < $lowLimit || $realPackVolume > $highLimit) {
                continue;
              }
            } else {
              list($lowLimit, $highLimit) = explode('-', $weightLimits);
              
              if ($realWeight < $lowLimit || $realWeight > $highLimit) {
                continue;
              }
            }
          }
          
          if (count($shipping_data) != 4) continue;
          
          list($rsPrice, $rsCurr) = explode(' ', $shipping_data[3]);
          list($rsMinDelay, $rsMaxDelay) = explode('-', $shipping_data[2]);
          list($lowLimit, $highLimit) = explode('-', $shipping_data[0]);

          if (isset($special_price) && $special_price) {
            if ($special_price < $lowLimit || $special_price > $highLimit) {
              continue;
            }
          } else {
            if ($price < $lowLimit || $price > $highLimit) {
              continue;
            }
          }
          
          $json['offers']['shippingDetails'] = array(
            '@type' => 'OfferShippingDetails',
            'shippingRate' => array(
              '@type' => 'MonetaryAmount',
              'value' => $rsPrice,
              'currency' => $rsCurr,
            ),
            'shippingDestination' => array(
              '@type' => 'DefinedRegion',
              'addressCountry' => $shipping_data[1],
            ),
            'deliveryTime' => array(
              '@type' => 'ShippingDeliveryTime',
              'handlingTime' => array(
                '@type' => 'QuantitativeValue',
                'minValue' => 0,
                'maxValue' => 0,
                'unitCode' => 'DAY',
              ),
              'transitTime' => array(
                '@type' => 'QuantitativeValue',
                'minValue' => $rsMinDelay,
                'maxValue' => $rsMaxDelay,
                'unitCode' => 'DAY',
              ),
            ),
          );
          
          break;
        }
      }
      
      if (!empty($config['returnPolicy'])) {
        $json['offers']['hasMerchantReturnPolicy'] = array(
          '@type' => 'MerchantReturnPolicy',
          'applicableCountry' => (strpos($config['return']['country'], ',') ? explode(',', $config['return']['country']) : $config['return']['country']),
          'merchantReturnDays' => $config['return']['delay'],
          'returnPolicyCategory' => 'https://schema.org/MerchantReturnFiniteReturnWindow',
          'returnMethod' => 'https://schema.org/ReturnByMail',
        );
        
        $returnFeesData = explode(' ', $config['return']['fees']);
        
        if ($returnFeesData[0] > 0) {
          //$json['offers']['hasMerchantReturnPolicy']['returnShippingFeesAmount'] = $config['return']['fees'];
          $json['offers']['hasMerchantReturnPolicy']['returnShippingFeesAmount']['value'] = $returnFeesData[0];
          
          if (isset($returnFeesData[1])) {
            $json['offers']['hasMerchantReturnPolicy']['returnShippingFeesAmount']['currency'] = $returnFeesData[1];
          }
          
          $json['offers']['hasMerchantReturnPolicy']['returnFees'] = 'https://schema.org/ReturnShippingFees';
        } else {
          $json['offers']['hasMerchantReturnPolicy']['returnShippingFeesAmount'] = 'https://schema.org/FreeReturn';
          $json['offers']['hasMerchantReturnPolicy']['returnFees'] = 'https://schema.org/FreeReturn';
        }
      }
      
      if ($data['product_info']['quantity'] > 0) {
        //$json['offers']['availability'] = 'https://schema.org/InStock';
        $json['offers']['availability'] = 'InStock';
      } else {
        $stockStatusQuery = $this->db->query("SELECT stock_status_id FROM " . DB_PREFIX . "product WHERE product_id = " . (int)$data['product_id'])->row;
        
        if (!empty($config['order_status'][$stockStatusQuery['stock_status_id']])) {
          //$json['offers']['availability'] = 'https://schema.org/'.$config['order_status'][$stockStatusQuery['stock_status_id']];
          $json['offers']['availability'] = $config['order_status'][$stockStatusQuery['stock_status_id']];
        }
      }
      
      if (!empty($config['reviews']) && count($data['reviews'])) {
        $best_rating = $review_total = 0;
        
        // get all reviews
        if (true) {
          $data['reviews'] = $this->model_catalog_review->getReviewsByProductId($data['product_id'], 0, 999999999999);
        }
        
        foreach ($data['reviews'] as $review) {
          $json['review'][] = array(
            '@type' => 'Review',
            'name' => !empty($data['product_info']['meta_title']) ? html_entity_decode($data['product_info']['meta_title'], ENT_QUOTES, 'UTF-8') : html_entity_decode($data['heading_title'], ENT_QUOTES, 'UTF-8'),
            'itemReviewed' => !empty($data['product_info']['meta_title']) ? html_entity_decode($data['product_info']['meta_title'], ENT_QUOTES, 'UTF-8') : html_entity_decode($data['heading_title'], ENT_QUOTES, 'UTF-8'),
            'author' => array(
              '@type' => 'Person',
              'name' => $review['author'],
            ),
            'reviewBody' => $review['text'],
            'datePublished' => date('Y-m-d', strtotime($review['date_added'])),
            'reviewRating' => array(
              '@type' => 'Rating',
              'ratingValue' => $review['rating'],
            ),
          );
            
          $review_total += $review['rating'];
          $best_rating = ($review['rating'] > $best_rating) ? $review['rating'] : $best_rating;
        }
        
        $json['aggregateRating'] = array(
          '@type' => 'AggregateRating',
          'ratingValue' => round($review_total / count($data['reviews']), 1),
          'bestRating' => $best_rating,
          'reviewCount' => count($data['reviews']),
        );
      }
      
      $output .= '<script type="application/ld+json">'.json_encode($json).'</script>'."\n";
    }
    
    // Organization
    if (in_array($page, array('home', 'contact')) && !empty($config['organization'])) {
      $json = array();
      $json['@context'] = 'http://schema.org';
      $json['@type'] = 'Organization';
      $json['url'] = $data['url'];
      $json['logo'] = $data['logo'];
    
      if (!empty($config['organization_search'])) {
        $json['potentialAction'][] = array(
          '@type' => 'SearchAction',
          'target' => urldecode($this->url->link('product/search', 'search={search_term_string}')),
          'query-input' => 'required name=search_term_string',
        );
      }
      
      if (!empty($config['contact'])) {
        foreach ($config['contact'] as $contact) {
          if (empty($contact['phone'])) continue;
          
          $json['contactPoint'][] = array(
            '@type' => 'ContactPoint',
            'telephone' => $contact['phone'],
            'contactType' => $contact['type'],
          );
        }
      }
      
      $output .= '<script type="application/ld+json">'.json_encode($json).'</script>'."\n";
    }
    
    // Store
    if (in_array($page, array('home', 'contact')) && !empty($config['store'])) {
      $json = array();
      $json['@context'] = 'http://schema.org';
      $json['@type'] = 'Store';
      $json['url'] = $data['url'];
      $json['name'] = $data['config_name'];
      $json['image'] = $data['logo'];
      
      if (!empty($config['store_logo'])) {
        $json['logo'] = $data['logo'];
      }
      
      if (!empty($config['store_mail'])) {
        $json['email'] = $this->config->get('config_email');
      }
      
      if (!empty($config['store_phone'])) {
        $json['telephone'] = $this->config->get('config_telephone');
      }
      
      if (!empty($config['address'])) {
        if (!empty($config['address_street'])) $json['address']['streetAddress'] = $config['address_street'];
        if (!empty($config['address_city'])) $json['address']['addressLocality'] = $config['address_city'];
        if (!empty($config['address_region'])) $json['address']['addressRegion'] = $config['address_region'];
        if (!empty($config['address_code'])) $json['address']['postalCode'] = $config['address_code'];
        if (!empty($config['address_country'])) $json['address']['addressCountry'] = $config['address_country'];
      }
      
      foreach ($config['same_as'] as $same_as) {
        if (empty($same_as)) continue;
        
        $json['sameAs'][] = $same_as;
      }
      
      if (!empty($config['pricerange'])) {
        $json['priceRange'][] = $config['pricerange'];
      }
      
      $output .= '<script type="application/ld+json">'.json_encode($json).'</script>'."\n";
    }
    
    // Website
    if (in_array($page, array('home', 'contact')) && !empty($config['website'])) {
      $json = array();
      $json['@context'] = 'http://schema.org';
      $json['@type'] = 'WebSite';
      $json['url'] = $data['url'];
      
      if (!empty($config['website_search'])) {
        $json['potentialAction'][] = array(
          '@type' => 'SearchAction',
          'target' => urldecode($this->url->link('product/search', 'search={search_term_string}')),
          'query-input' => 'required name=search_term_string',
        );
      }
      
      $output .= '<script type="application/ld+json">'.json_encode($json).'</script>'."\n";
    }
    
    // Place
    if (in_array($page, array('home', 'contact')) && !empty($config['place'])) {
      $json = array();
      $json['@context'] = 'http://schema.org';
      $json['@type'] = 'Place';
      $json['name'] = $data['config_name'];
      
      if (!empty($config['gps_lat']) && !empty($config['gps_long'])) {
        $json['geo'] = array(
          '@type' => 'GeoCoordinates',
          'latitude' => $config['gps_lat'],
          'longitude' => $config['gps_long'],
        );
      }
      
      $output .= '<script type="application/ld+json">'.json_encode($json).'</script>'."\n";
    }
    
    // Journal
    if (in_array($page, array('journal3/blog/post')) && !empty($data['post_name'])) {
      $lastBc = array_pop($data['breadcrumbs']);
      
      $json = array();
      $json['@context'] = 'http://schema.org';
      $json['@type'] = 'BlogPosting';
      $json['@id'] = $lastBc['href'];
      $json['headline'] = $data['post_name'];
      $json['image'] = array($data['post_image']);
      $json['author'] = $data['post_author'];
      $json['datePublished'] = date('c', strtotime($data['post_date']));
      
      if (date('Y', strtotime($data['post_date_edited'])) > 2000) {
        $json['dateModified'] = date('c', strtotime($data['post_date_edited']));
      }
      
      $json['author'] = array(
        '@type' => 'Person',
        'name' => $data['post_author'],
      );
      
      if (!empty($config['same_as'][0])) {
        $json['author']['url'] = $config['same_as'][0];
      }
      
      $output .= '<script type="application/ld+json">'.json_encode($json).'</script>'."\n";
    }
    
    if ($output) {
      $output = "<!-- Microdata -->\n".$output."\n";
    }
    
    return $output;
  }
  
  public function checkCanonical() {
    if (!$this->config->get('mlseo_canonical')) {
      return;
    }
    
    foreach ($this->document->getLinks() as $link) {
      if ($link['rel'] == 'canonical') {
        return;
      }
    }
    
    /*/ no canonical for search page
    if (!empty($this->request->get['route']) && $this->request->get['route'] == 'product/search') {
      return;
    } */
    
    if (isset($this->request->get['route']) && $this->request->get['route'] != 'common/home') {
      list($ctrl) = explode('/', $this->request->get['route']);
      
      if (in_array($ctrl, array('account', 'information', 'affiliate', 'checkout'))) {
        $data = $this->request->get;
        
        
        $route = $data['route'];
        $params = '';
        
        unset($data['_route_'], $data['route']);
        
        if ($data) {
          $params = urldecode(http_build_query($data, '', '&'));
        }  
        
        $this->document->addLink($this->url->link($route, $params), 'canonical');
      }
    } else {
      $this->document->addLink($this->url->link('common/home'), 'canonical');
    }
  }
  
  public function addUrl404($url) {
    $url = strip_tags($url); // prevent xss
    
    $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "url_404 WHERE query = '" . $this->db->escape($url) . "'")->row;
    
    $referer = !empty($_SERVER['HTTP_REFERER']) && !is_null($_SERVER['HTTP_REFERER']) && PHP_URL_HOST ? preg_replace('/^www\./', '', (parse_url($_SERVER['HTTP_REFERER'], PHP_URL_HOST) ? parse_url($_SERVER['HTTP_REFERER'], PHP_URL_HOST) : '')) : '';
    $agent = !empty($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '';
    
    if (!empty($agent)) {
      if (strpos($agent, 'Googlebot') !== false) {
        $agent = 'Google';
      } else if (strpos($agent, 'PetalBot') !== false) {
        $agent = 'PetalSearch';
      } else if (strpos($agent, 'Applebot') !== false) {
        $agent = 'Apple';
      } else if (strpos($agent, 'Yeti') !== false) {
        $agent = 'Yeti';
      } else if (strpos($agent, 'coccocbot') !== false) {
        $agent = 'CocCoc';
      } else if (strpos($agent, 'Bingbot') !== false) {
        $agent = 'Bing';
      } else if (strpos($agent, 'Slurp') !== false) {
        $agent = 'Yahoo';
      } else if (strpos($agent, 'DuckDuckBot') !== false) {
        $agent = 'DuckDuckGo';
      } else if (strpos($agent, 'Baiduspider') !== false) {
        $agent = 'Baidu';
      } else if (strpos($agent, 'YandexBot') !== false) {
        $agent = 'Yandex';
      } else if (strpos($agent, 'Sogou') !== false) {
        $agent = 'Sogou';
      } else if (strpos($agent, 'Exabot') !== false) {
        $agent = 'Exalead';
      } else if (strpos($agent, 'facebot') !== false) {
        $agent = 'Facebook';
      } else if (strpos($agent, 'ia_archiver') !== false) {
        $agent = 'Alexa';
      } else if (strpos($agent, 'SeznamBot') !== false) {
        $agent = 'Seznam';
      } else {
        $agent = '';
      }
    }
    
    if (!empty($agent)) {
      $referer = 'Bot:'.$agent;
    }
    
    if (isset($query['count'])) {
      if (empty($query['referer'])) {
        $query['referer'] = $referer;
      } else if ($referer && !empty($query['referer'])) {
        if (strpos($query['referer'], $referer) === false) {
          $query['referer'] = $query['referer'] . ', ' . $referer;
        }
      }
      
      $this->db->query("UPDATE " . DB_PREFIX . "url_404 SET count = '".($query['count']+1)."', referer = '". $this->db->escape($query['referer']) . "', date_accessed = NOW() WHERE url_404_id = '". $query['url_404_id'] . "'");
    } else {
      $this->db->query("INSERT INTO " . DB_PREFIX . "url_404 SET query = '". $this->db->escape($url) . "', referer = '". $this->db->escape($referer) . "', count = 1");
    }
  }
  
  public function ggAnalytics() {
    $ggScript = '';
    
    $seo_meta = $this->config->get('mlseo_store');
    /*
    if (!empty($seo_meta[$this->config->get('config_store_id')]['gg_analytics']) && !empty($seo_meta[$this->config->get('config_store_id')]['gg_enhanced'])) {
      $this->document->addScript('index.php?route=geekodev/analytics', 'footer');
      //$ggScript .= '<script src="'.$this->url->link('geekodev/analytics').'" type="text/javascript"></script>'."\n";
    }
    */
    if (!empty($seo_meta[$this->config->get('config_store_id')]['gg_analytics']) && !empty($seo_meta[$this->config->get('config_store_id')]['analytics'])) {
      $ggAnalyticsCode = html_entity_decode($seo_meta[$this->config->get('config_store_id')]['analytics'], ENT_QUOTES, 'UTF-8');
      
      // Google Analytics 4
      if (substr($ggAnalyticsCode, 0, 2) == 'G-') {
        if (true) {
          $debug = ",{'debug_mode':true}";
        } else {
          $debug = '';
        }
        
        $ggScript .= "<script async src=\"https://www.googletagmanager.com/gtag/js?id=".$ggAnalyticsCode."\"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());
  gtag('config', '".$ggAnalyticsCode."'".$debug.");
</script>
";

      // Google Analytics 3
      } else {
        $ggScript .= '<script async src="https://www.googletagmanager.com/gtag/js?id='.$ggAnalyticsCode.'"></script>'."\n";
        $ggScript .= "<script>window.dataLayer = window.dataLayer || []; function gtag(){dataLayer.push(arguments);} gtag('js', new Date()); gtag('config', '".$ggAnalyticsCode."');</script>\n";
      }
    }
    
    if (!empty($seo_meta[$this->config->get('config_store_id')]['gg_adwords']) && !empty($seo_meta[$this->config->get('config_store_id')]['adwords'])) {
      $ggAdwordsCode = $seo_meta[$this->config->get('config_store_id')]['adwords'];
      
      $ggScript .= '<script async src="https://www.googletagmanager.com/gtag/js?id='.$ggAdwordsCode.'"></script>'."\n";
      $ggScript .= "<script>window.dataLayer = window.dataLayer || []; function gtag(){dataLayer.push(arguments);} gtag('js', new Date()); gtag('config', '".$ggAdwordsCode."');</script>\n";
    }
    
    if (!empty($seo_meta[$this->config->get('config_store_id')]['gg_analytics']) && !empty($seo_meta[$this->config->get('config_store_id')]['analytics'])) {
      $ggAnalyticsCode = html_entity_decode($seo_meta[$this->config->get('config_store_id')]['analytics'], ENT_QUOTES, 'UTF-8');
      
      // Google Analytics 4
      if (substr($ggAnalyticsCode, 0, 2) == 'G-') {
        // transaction complete
        if (isset($this->request->get['route']) && in_array($this->request->get['route'], array('checkout/success'))) {
          if (!empty($seo_meta[$this->config->get('config_store_id')]['gg_analytics']) && !empty($seo_meta[$this->config->get('config_store_id')]['gg_enhanced'])) {
            if (isset($this->session->data['ggAnalytics_order_id'])) {
              $order_id = $this->session->data['ggAnalytics_order_id'];
              unset($this->session->data['ggAnalytics_order_id']);
              
              $trackData = $this->getTrackData(array('action' => 'purchase', 'order_id' => $order_id));
              
              $ggScript .= "  <script>gtag('event', 'purchase', ".json_encode($trackData).");</script>\n";
            }
          }
        } else if (isset($this->request->get['route']) && in_array($this->request->get['route'], array('product/product')) && !empty($this->request->get['product_id'])) {
          if (!empty($seo_meta[$this->config->get('config_store_id')]['gg_analytics']) && !empty($seo_meta[$this->config->get('config_store_id')]['gg_enhanced'])) {
            $trackData = $this->getTrackData(array('action' => 'item_view', 'product_id' => $this->request->get['product_id']));
            
            $ggScript .= "  <script>gtag('event', 'item_view', ".json_encode($trackData).");</script>\n";
          }
        }
        
      // Google Analytics 3
      } else {
        $ggScript .= "<script>
(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
})(window,document,'script','https://www.google-analytics.com/analytics.js','ga');
ga('create', '".$ggAnalyticsCode."', 'auto');\n";

        if (!empty($seo_meta[$this->config->get('config_store_id')]['gg_enhanced'])) {
          $ggScript .= "ga('require', 'ec');\n";
        }

        $ggScript .= "ga('send', 'pageview');\n";

        if (isset($this->request->get['route']) && in_array($this->request->get['route'], array('checkout/checkout'))) {
          //$ggScript .= "gkdEctTrackCheckout(1, 'Enter checkout');\n";
        }
        
        if (isset($this->request->get['route']) && in_array($this->request->get['route'], array('account/login', 'account/register', 'checkout/cart', 'checkout/checkout'))) {
          list($cat, $action) = explode('/', $this->request->get['route']);
          $ggScript .= "ga('send', 'event', '".ucfirst($cat)."', '".ucfirst($action)."');\n";
        }
        
        // transaction complete
        if (isset($this->request->get['route']) && in_array($this->request->get['route'], array('checkout/success'))) {
          if (!empty($seo_meta[$this->config->get('config_store_id')]['gg_analytics']) && !empty($seo_meta[$this->config->get('config_store_id')]['gg_enhanced'])) {
            if (isset($this->session->data['ggAnalytics_order_id'])) {
              $order_id = $this->session->data['ggAnalytics_order_id'];
              unset($this->session->data['ggAnalytics_order_id']);

              $this->load->model('checkout/order');
              $this->load->model('account/order');

              $order_info = $this->model_checkout_order->getOrder($order_id);

              if ($order_info) {
                $subTotal = $tax = $shipping = 0;
                $coupon = '';
                
                foreach ($this->model_account_order->getOrderTotals($order_id) as $order_total) {
                  if ($order_total['code'] == 'tax') {
                    $tax += $order_total['value'];
                  } elseif($order_total['code'] == 'shipping') {
                    $shipping += $order_total['value'];
                  } elseif($order_total['code'] == 'sub_total') {
                    $subTotal += $order_total['value'];
                  } elseif($order_total['code'] == 'coupon') {
                    $coupon = $order_total['title'];
                  }
                }
                
                // calculate total and prices
                if (1 || !empty($seo_meta[$this->config->get('config_store_id')]['gg_tax'])) {
                  $total = $order_info['total'];
                } else {
                  $total = $subTotal;
                }
                
                if (!empty($seo_meta[$this->config->get('config_store_id')]['gg_currency'])) {
                  $total = $this->currency->convert($this->currency->format($total, $order_info['currency_code'], $order_info['currency_value'], false), $order_info['currency_code'], $seo_meta[$this->config->get('config_store_id')]['gg_currency']);
                  $tax = $this->currency->convert($this->currency->format($tax, $order_info['currency_code'], $order_info['currency_value'], false), $order_info['currency_code'], $seo_meta[$this->config->get('config_store_id')]['gg_currency']);
                  $shipping = $this->currency->convert($this->currency->format($shipping, $order_info['currency_code'], $order_info['currency_value'], false), $order_info['currency_code'], $seo_meta[$this->config->get('config_store_id')]['gg_currency']);
                } else {
                  $total = $this->currency->format($total, $order_info['currency_code'], $order_info['currency_value'], false);
                  $tax = $this->currency->format($tax, $order_info['currency_code'], $order_info['currency_value'], false);
                  $shipping = $this->currency->format($shipping, $order_info['currency_code'], $order_info['currency_value'], false);
                }
                
                $total = round($total, 2);
                $tax = round($tax, 2);
                
                $purchase = array(
                  'id' => $order_info['order_id'],
                  'revenue' => $total,
                  'tax' => $tax,
                  'shipping' => $shipping,
                  'coupon' => $coupon,
                );
                
                if (!empty($order_info['affiliate_id'])) {
                  $affiliate_id = $order_info['affiliate_id'];
                  
                  if (version_compare(VERSION, '3', '>=')) {
                    $this->load->model('account/customer');
                    $affiliate_info = $this->model_account_customer->getAffiliate($affiliate_id);
                  } else {
                    $this->load->model('affiliate/affiliate');
                    $affiliate_info = $this->model_affiliate_affiliate->getAffiliate($affiliate_id);
                  }
                  
                  $purchase['affiliation'] = $affiliate_info['code'];
                }
                
                $ggScript .= "ga('ec:setAction', 'purchase'," . json_encode($purchase) . ");\n";
                
                // set track products
                $trackProducts = $this->getTrackData(array('order_id' => $order_id));
                
                foreach($trackProducts as $prod) {
                  $ggScript .= "ga('ec:addProduct', " . json_encode($prod) . ");\n";
                }
              }
            }
          }
        }
        
        $ggScript .= "if (window.performance) {
    var timeSincePageLoad = Math.round(performance.now());
    ga('send', 'timing', 'Page Load Time', 'load', timeSincePageLoad);
  }";
      
        $ggScript .= "</script>";
      }
    }
    
    if (!empty($ggScript)) {
      $this->document->addSeoMeta("\n<!-- gkdAnalytics -->\n".$ggScript."\n\n");
    }
    
    if (!$this->config->get('mlseo_hreflang')) {
      return;
    }
    
    if (!empty($seo_meta[$this->config->get('config_store_id')]['gg_analytics']) && !empty($seo_meta[$this->config->get('config_store_id')]['gg_enhanced'])) {
    }
  }
  
  public function getTrackData($data = array()) {
    $json = array();
    
    $json['currency'] = $this->session->data['currency'];
    
    if (!empty($this->request->post['action'])) {
      $action = $this->request->post['action'];
    } else if (!empty($data['action'])) {
      $action = $data['action'];
    } else {
      $action = 'default';
    }
    
    $order_products_qty = array();
    
    if (!empty($this->request->post['cart'])) {
      $this->request->post['pid'] = array();
      
      foreach($this->cart->getProducts() as $prod) {
        $this->request->post['pid'][] = $prod['product_id'];
      }
    } else if (!empty($data['order_id'])) {
      $this->request->post['pid'] = array();
      
      $this->load->model('checkout/order');
			$this->load->model('account/order');
      
      $order_info = $this->model_checkout_order->getOrder($data['order_id']);
      $order_products = $this->model_account_order->getOrderProducts($data['order_id']);
      foreach($order_products as $prod) {
        $order_products_qty[$prod['product_id']] = $prod['quantity'];
        $this->request->post['pid'][] = $prod['product_id'];
      }
    } else if (!empty($data['product_id'])) {
      $this->request->post['pid'] = array($data['product_id']);
    }
    
    // purchase data
    if ($action == 'purchase' && !empty($order_info)) {
      $subTotal = $tax = $shipping = 0;
      $coupon = '';
      
      foreach ($this->model_account_order->getOrderTotals($order_info['order_id']) as $order_total) {
        if ($order_total['code'] == 'tax') {
          $tax += $order_total['value'];
        } elseif($order_total['code'] == 'shipping') {
          $shipping += $order_total['value'];
        } elseif($order_total['code'] == 'sub_total') {
          $subTotal += $order_total['value'];
        } elseif($order_total['code'] == 'coupon') {
          $coupon = $order_total['title'];
        }
      }
      
      // calculate total and prices
      if (1 || !empty($seo_meta[$this->config->get('config_store_id')]['gg_tax'])) {
        $total = $order_info['total'];
      } else {
        $total = $subTotal;
      }
      
      if (!empty($seo_meta[$this->config->get('config_store_id')]['gg_currency'])) {
        $total = $this->currency->convert($this->currency->format($total, $order_info['currency_code'], $order_info['currency_value'], false), $order_info['currency_code'], $seo_meta[$this->config->get('config_store_id')]['gg_currency']);
        $tax = $this->currency->convert($this->currency->format($tax, $order_info['currency_code'], $order_info['currency_value'], false), $order_info['currency_code'], $seo_meta[$this->config->get('config_store_id')]['gg_currency']);
        $shipping = $this->currency->convert($this->currency->format($shipping, $order_info['currency_code'], $order_info['currency_value'], false), $order_info['currency_code'], $seo_meta[$this->config->get('config_store_id')]['gg_currency']);
      } else {
        $total = $this->currency->format($total, $order_info['currency_code'], $order_info['currency_value'], false);
        $tax = $this->currency->format($tax, $order_info['currency_code'], $order_info['currency_value'], false);
        $shipping = $this->currency->format($shipping, $order_info['currency_code'], $order_info['currency_value'], false);
      }
      
      $total = round($total, 2);
      $tax = round($tax, 2);
      
      $json = array(
        'transaction_id' => $order_info['order_id'],
        'currency' => $order_info['currency_code'],
        'value' => $total,
        'tax' => $tax,
      );
      
      if (!empty($shipping)) {
        $json['shipping'] = $shipping;
      }
      
      if (!empty($coupon)) {
        $json['coupon'] = $coupon;
      }
      
      if (!empty($order_info['affiliate_id'])) {
        $affiliate_id = $order_info['affiliate_id'];
        
        if (version_compare(VERSION, '3', '>=')) {
          $this->load->model('account/customer');
          $affiliate_info = $this->model_account_customer->getAffiliate($affiliate_id);
        } else {
          $this->load->model('affiliate/affiliate');
          $affiliate_info = $this->model_affiliate_affiliate->getAffiliate($affiliate_id);
        }
        
        $purchase['affiliation'] = $affiliate_info['code'];
      }
    }
    
    // items
    if (!empty($this->request->post['pid'])) {
      $this->load->model('catalog/product');
      $this->load->model('catalog/category');
      $this->load->model('tool/path_manager');

      foreach ((array) $this->request->post['pid'] as $product_id) {
        if (version_compare(VERSION, '3', '>=') && $action == 'remove') {
          $cart_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "cart WHERE api_id = '" . (isset($this->session->data['api_id']) ? (int)$this->session->data['api_id'] : 0) . "' AND customer_id = '" . (int)$this->customer->getId() . "' AND session_id = '" . $this->db->escape($this->session->getId()) . "' AND cart_id = '" . (int)$product_id . "'")->row;
          
          if (isset($cart_query['product_id'])) {
            $product_id = $cart_query['product_id'];
          }
        }
        
        $product_info = $this->model_catalog_product->getProduct($product_id);
        
        if ($product_info && !empty($product_info['product_id'])) {
          if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
            $data['price'] = $this->currency->format($this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency'], '', false);
          } else {
            $data['price'] = false;
          }

          if ((float)$product_info['special']) {
            $data['special'] = $this->currency->format($this->tax->calculate($product_info['special'], $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency'], '', false);
          } else {
            $data['special'] = false;
          }
          
          $path = $this->model_tool_path_manager->getOneProductPath($product_info['product_id']);
          
          $productPath = '';
          
          if (!empty($path)) {
            foreach(explode('_', $path) as $catId) {
              $category_info = $this->model_catalog_category->getCategory($catId);
              
              if ($category_info) {
                $productPath .= ($productPath ? '/' : '') . $category_info['name'];
              }
            }
          }
        
          $prodData = array(
            'item_id' => $product_info['product_id'],
            'item_name' => $product_info['name'],
            'quantity' => ( !empty($order_products_qty) && !empty($order_products_qty[$product_info['product_id']]) ) ? $order_products_qty[$product_info['product_id']] : 1,
          );
          
          if ($productPath) {
            $prodData['item_category'] = $productPath;
          }
          
          if ($product_info['manufacturer']) {
            $prodData['item_brand'] = $product_info['manufacturer'];
          }
          
          if ($data['price']) {
            $prodData['price'] = $data['price'];
          }
          
          if (!empty($total) && !isset($json['value'])) {
            $json['value'] = $total;
          }
          
          $json['items'][] = $prodData;
        }
      }
    }
    
    return $json;
    // header('Content-Type: application/json');
    // echo json_encode($json);
  }
}