<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* extension/theme/antonio/antonio.twig */
class __TwigTemplate_4e26b660439e2b5a69b10dedd52b1ffcef33ccfac7819a866923db9a07ae5f02 extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 1
        echo "<!--**********************************
*** ANTONIO 2.5 RTL + OpenCart Login Integration
*** Developer: Adpro Infotech  
*** Email: prosenjeet123@gmail.com
*************************************-->
<!DOCTYPE html>
<html lang=\"ar\" dir=\"rtl\">
  <head>
    <meta charset=\"UTF-8\" />
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\" />
    <title>M2Store - دخول لوحة التحكم</title>
    <link rel=\"icon\" type=\"image/x-icon\" href=\"https://m2.ist/image/m2store.png\">
    <link rel=\"stylesheet\" href=\"view/stylesheet/bootstrapv5.min.css\" />
    <link rel=\"preconnect\" href=\"https://fonts.googleapis.com\">
    <link rel=\"preconnect\" href=\"https://fonts.gstatic.com\" crossorigin>
    <link href=\"https://fonts.googleapis.com/css2?family=Cairo:wght@200;300;400;500;600;700;800;900&display=swap\" rel=\"stylesheet\">
    <link href=\"view/stylesheet/front-main.min.css\" rel=\"stylesheet\"/>

    <!-- jquery-->
    <script src=\"view/javascript/jquery/jquery-2.1.1.min.js\"></script>
    <script src=\"view/javascript/antonio/bootstrap-pincode-input.js\" type=\"text/javascript\"></script>
    

     <style>
        :root {
            --primary-gradient: linear-gradient(135deg, #5B6BF7 0%, #7C3AED 100%);
            --secondary-gradient: linear-gradient(135deg, #EC4899 0%, #F43F5E 100%);
            --accent-gradient: linear-gradient(135deg, #06B6D4 0%, #3B82F6 100%);
            --success-gradient: linear-gradient(135deg, #10B981 0%, #059669 100%);
            --warning-gradient: linear-gradient(135deg, #F59E0B 0%, #D97706 100%);
            --danger-gradient: linear-gradient(135deg, #EF4444 0%, #DC2626 100%);
            
            --brand-primary: #5B6BF7;
            --brand-secondary: #EC4899;
            --brand-accent: #7C3AED;
            
            --glass-primary: rgba(255, 255, 255, 0.15);
            --glass-secondary: rgba(255, 255, 255, 0.08);
            --glass-border: rgba(255, 255, 255, 0.25);
            
            --shadow-subtle: 0 8px 32px rgba(91, 107, 247, 0.15);
            --shadow-medium: 0 15px 35px rgba(91, 107, 247, 0.25);
            --shadow-strong: 0 25px 50px rgba(91, 107, 247, 0.35);
            
            --text-primary: #1e293b;
            --text-secondary: #64748b;
            --text-light: #94a3b8;
            --text-white: #ffffff;
            
            --cairo-font: \"Cairo\", sans-serif;
            --transition-smooth: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            --transition-bounce: all 0.4s cubic-bezier(0.68, -0.55, 0.265, 1.55);
        }

        * {
            font-family: var(--cairo-font) !important;
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body, html {
            font-family: var(--cairo-font) !important;
            overflow-x: hidden;
            direction: rtl;
            text-align: right;
        }
        
        /* خلفية ديناميكية */
        .advanced-background {
            background: linear-gradient(135deg, #5B6BF7, #7C3AED, #EC4899, #F43F5E, #06B6D4, #3B82F6);
            background-size: 600% 600%;
            min-height: 100vh;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            overflow: hidden;
            animation: ultraSmoothGradient 30s ease-in-out infinite;
            z-index: 1;
        }
        
        @keyframes ultraSmoothGradient {
            0% { background-position: 0% 50%; }
            25% { background-position: 25% 75%; }
            50% { background-position: 100% 50%; }
            75% { background-position: 75% 25%; }
            100% { background-position: 0% 50%; }
        }
        
        /* طبقات متحركة */
        .floating-layers {
            position: absolute;
            width: 100%;
            height: 100%;
            z-index: 2;
            pointer-events: none;
        }
        
        .layer {
            position: absolute;
            border-radius: 50%;
            background: var(--glass-primary);
            backdrop-filter: blur(15px);
            border: 1px solid var(--glass-border);
            animation: float3D 35s infinite ease-in-out;
            opacity: 0.3;
        }
        
        .layer:nth-child(1) {
            width: 280px;
            height: 280px;
            top: -140px;
            left: -140px;
            animation-delay: 0s;
        }
        
        .layer:nth-child(2) {
            width: 220px;
            height: 220px;
            bottom: -110px;
            right: -110px;
            animation-delay: 12s;
        }
        
        .layer:nth-child(3) {
            width: 180px;
            height: 180px;
            top: 30%;
            left: -90px;
            animation-delay: 24s;
        }
        
        @keyframes float3D {
            0%, 100% { 
                transform: translateY(0px) translateX(0px) rotateZ(0deg) scale(1);
                opacity: 0.2;
            }
            50% { 
                transform: translateY(-20px) translateX(10px) rotateZ(180deg) scale(1.05);
                opacity: 0.4;
            }
        }
        
        /* أيقونات متحركة */
        .icon-network {
            position: absolute;
            width: 100%;
            height: 100%;
            z-index: 3;
            pointer-events: none;
        }
        
        .network-node {
            position: absolute;
            width: 60px;
            height: 60px;
            background: var(--glass-primary);
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            backdrop-filter: blur(20px);
            border: 2px solid var(--glass-border);
            box-shadow: var(--shadow-medium);
            transition: var(--transition-smooth);
            animation: nodeFloat 20s infinite ease-in-out;
            opacity: 0.7;
        }
        
        .network-node svg {
            width: 30px;
            height: 30px;
            fill: var(--text-white);
            filter: drop-shadow(0 4px 8px rgba(0,0,0,0.2));
        }
        
        @keyframes nodeFloat {
            0%, 100% { 
                transform: translateY(0px) rotate(0deg);
            }
            50% { 
                transform: translateY(-15px) rotate(180deg);
            }
        }
        
        /* مواضع الأيقونات */
        .network-node:nth-child(1) { top: 5%; right: 8%; animation-delay: 0s; }
        .network-node:nth-child(2) { top: 15%; left: 5%; animation-delay: 2s; }
        .network-node:nth-child(3) { top: 25%; right: 15%; animation-delay: 4s; }
        .network-node:nth-child(4) { top: 35%; left: 12%; animation-delay: 6s; }
        .network-node:nth-child(5) { top: 45%; right: 5%; animation-delay: 8s; }
        .network-node:nth-child(6) { top: 55%; left: 8%; animation-delay: 10s; }
        .network-node:nth-child(7) { top: 65%; right: 12%; animation-delay: 12s; }
        .network-node:nth-child(8) { top: 75%; left: 15%; animation-delay: 14s; }
        .network-node:nth-child(9) { bottom: 15%; right: 20%; animation-delay: 16s; }
        .network-node:nth-child(10) { bottom: 25%; left: 10%; animation-delay: 18s; }
        
        /* التخطيط الرئيسي */
        .main-layout {
            display: grid;
            grid-template-columns: 30% 70%;
            min-height: 100vh;
            position: relative;
            z-index: 100;
        }
        
        /* قسم تسجيل الدخول - يمين */
        .auth-panel {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(25px);
            border-left: 1px solid var(--glass-border);
            display: flex;
            flex-direction: column;
            justify-content: center;
            padding: 50px 30px;
            position: relative;
            box-shadow: var(--shadow-strong);
            z-index: 200;
        }
        
        .auth-container {
            max-width: 100%;
            margin: 0 auto;
            width: 100%;
            position: relative;
            z-index: 300;
        }
        
        /* شعار كبير */
        .m2store-logo {
            text-align: center;
            margin-bottom: 40px;
            position: relative;
            z-index: 400;
        }
        
        .m2store-logo img {
            width: 280px;
            height: auto;
            transition: var(--transition-smooth);
            position: relative;
            z-index: 500;
            filter: drop-shadow(0 10px 30px rgba(91, 107, 247, 0.3));
        }
        
        .m2store-logo:hover img {
            transform: scale(1.05) rotate(3deg);
        }
        
        /* عنوان النموذج */
        .form-title {
            text-align: center;
            margin-bottom: 30px;
            position: relative;
            z-index: 300;
        }
        
        .form-title h1 {
            font-size: 2.2rem;
            font-weight: 800;
            background: var(--primary-gradient);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 8px;
        }
        
        .form-title p {
            color: var(--text-secondary);
            font-size: 1rem;
            font-weight: 500;
            opacity: 0.8;
        }

        /* رسائل الخطأ - OpenCart Standard */
        .alert {
            padding: 15px;
            margin-bottom: 20px;
            border: 1px solid transparent;
            border-radius: 12px;
            position: relative;
            z-index: 300;
        }

        .alert-danger {
            color: #721c24;
            background-color: #f8d7da;
            border-color: #f5c6cb;
            background: var(--danger-gradient);
            color: white;
            font-weight: 600;
            text-align: center;
        }

        .alert-success {
            color: #155724;
            background-color: #d4edda;
            border-color: #c3e6cb;
            background: var(--success-gradient);
            color: white;
            font-weight: 600;
            text-align: center;
        }
        
        /* مجموعات النموذج - OpenCart Compatible */
        .form-group {
            margin-bottom: 22px;
            position: relative;
            z-index: 500;
            width: 100%;
        }
        
        .input-wrapper {
            position: relative;
            border-radius: 14px;
            background: var(--glass-secondary);
            backdrop-filter: blur(10px);
            border: 2px solid transparent;
            transition: var(--transition-smooth);
            z-index: 600;
            width: 100%;
        }
        
        .input-wrapper:focus-within {
            border-color: var(--brand-primary);
            background: rgba(255, 255, 255, 0.15);
            transform: translateY(-2px);
            box-shadow: var(--shadow-medium);
        }
        
        /* OpenCart Standard Input Classes */
        .form-control {
            width: 100%;
            padding: 16px 50px 16px 18px;
            border: none !important;
            background: transparent !important;
            font-size: 15px;
            font-weight: 500;
            color: var(--text-primary) !important;
            transition: var(--transition-smooth);
            outline: none !important;
            position: relative;
            z-index: 700;
            box-shadow: none !important;
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
        }
        
        .form-control::placeholder {
            color: var(--text-light);
            font-weight: 400;
        }
        
        .form-control:focus {
            border: none !important;
            background: transparent !important;
            box-shadow: none !important;
            outline: none !important;
        }
        
        .input-icon {
            position: absolute;
            right: 16px;
            top: 50%;
            transform: translateY(-50%);
            width: 20px;
            height: 20px;
            fill: var(--text-light);
            transition: var(--transition-bounce);
            z-index: 600;
            pointer-events: none;
        }
        
        .input-wrapper:focus-within .input-icon {
            fill: var(--brand-primary);
            transform: translateY(-50%) scale(1.2) rotate(10deg);
        }
        
        /* OpenCart Standard Button Classes */
        .btn {
            display: inline-block;
            font-weight: 400;
            text-align: center;
            white-space: nowrap;
            vertical-align: middle;
            user-select: none;
            border: 1px solid transparent;
            padding: 0.375rem 0.75rem;
            font-size: 1rem;
            line-height: 1.5;
            border-radius: 0.25rem;
            transition: var(--transition-smooth);
            cursor: pointer;
            text-decoration: none;
        }

        .btn-primary {
            width: 100%;
            padding: 16px;
            background: var(--primary-gradient) !important;
            border: none !important;
            border-radius: 14px;
            color: var(--text-white) !important;
            font-size: 16px;
            font-weight: 700;
            cursor: pointer;
            transition: var(--transition-smooth);
            position: relative;
            overflow: hidden;
            text-transform: uppercase;
            letter-spacing: 1px;
            box-shadow: var(--shadow-medium);
            z-index: 500;
            margin-bottom: 18px;
            outline: none !important;
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
        }
        
        .btn-primary:hover {
            transform: translateY(-3px) scale(1.02);
            box-shadow: var(--shadow-strong);
            background: var(--secondary-gradient) !important;
            color: var(--text-white) !important;
        }
        
        .btn-primary:focus {
            outline: none !important;
            border: none !important;
            box-shadow: var(--shadow-strong) !important;
        }
        
        .btn-primary:active {
            transform: translateY(-1px) scale(0.98);
        }
        
        /* رابط نسيان كلمة المرور */
        .forgot-link {
            text-align: center;
            margin-top: 12px;
            position: relative;
            z-index: 500;
        }
        
        .forgot-link a {
            color: var(--text-secondary);
            text-decoration: none;
            font-weight: 600;
            transition: var(--transition-smooth);
        }
        
        .forgot-link a:hover {
            color: var(--brand-primary);
        }
        
        /* قسم المعلومات */
        .info-panel {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 60px 55px;
            text-align: center;
            position: relative;
            z-index: 150;
        }
        
        .info-content {
            max-width: 700px;
            z-index: 200;
        }
        
        .dynamic-text {
            color: var(--text-white);
            text-shadow: 0 2px 8px rgba(0,0,0,0.3);
        }
        
        .main-heading {
            font-size: 4.5rem;
            font-weight: 900;
            margin-bottom: 25px;
            text-shadow: 0 4px 15px rgba(0,0,0,0.4);
        }
        
        .sub-heading {
            font-size: 1.6rem;
            font-weight: 400;
            opacity: 0.95;
            margin-bottom: 45px;
            line-height: 1.6;
            text-shadow: 0 2px 10px rgba(0,0,0,0.3);
        }
        
        /* شبكة المميزات */
        .features-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 28px;
            max-width: 600px;
        }
        
        .feature-card {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-align: center;
            gap: 15px;
            padding: 32px 22px;
            background: var(--glass-primary);
            border-radius: 24px;
            backdrop-filter: blur(20px);
            border: 2px solid var(--glass-border);
            transition: var(--transition-bounce);
            position: relative;
            overflow: hidden;
            min-height: 150px;
        }
        
        .feature-card:hover {
            transform: translateY(-10px) scale(1.05);
            background: rgba(255, 255, 255, 0.25);
            box-shadow: var(--shadow-strong);
        }
        
        .feature-icon-wrapper {
            width: 65px;
            height: 65px;
            background: var(--secondary-gradient);
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 5px;
            transition: var(--transition-bounce);
            box-shadow: 0 8px 25px rgba(236, 72, 153, 0.3);
        }
        
        .feature-card:hover .feature-icon-wrapper {
            transform: scale(1.15) rotate(10deg);
            background: var(--warning-gradient);
        }
        
        .feature-icon {
            width: 32px;
            height: 32px;
            fill: var(--text-white);
        }
        
        .feature-text {
            font-size: 1.05rem;
            font-weight: 700;
            color: var(--text-white);
            text-shadow: 0 1px 4px rgba(0,0,0,0.3);
            line-height: 1.4;
        }
        
        .feature-description {
            font-size: 0.9rem;
            font-weight: 400;
            color: rgba(255, 255, 255, 0.8);
            text-shadow: 0 1px 2px rgba(0,0,0,0.2);
            line-height: 1.3;
        }
        
        /* معلومات إضافية */
        .additional-info {
            margin-top: 45px;
        }
        
        .help-text {
            font-size: 1.15rem;
            opacity: 0.9;
            margin-bottom: 15px;
            text-shadow: 0 1px 4px rgba(0,0,0,0.3);
        }
        
        .contact-link {
            color: #fbbf24;
            text-decoration: none;
            font-weight: 700;
            transition: var(--transition-smooth);
            text-shadow: 0 1px 4px rgba(0,0,0,0.3);
        }
        
        .contact-link:hover {
            color: #f59e0b;
            transform: translateX(-5px);
        }
        
        /* التجاوب للموبايل */
        @media (max-width: 1024px) {
            .main-layout {
                grid-template-columns: 35% 65%;
            }
            
            .m2store-logo img {
                width: 240px;
            }
        }
        
        @media (max-width: 768px) {
            .main-layout {
                grid-template-columns: 1fr;
                grid-template-rows: auto 1fr;
            }
            
            .auth-panel {
                order: 2;
                padding: 30px 20px;
                border-left: none;
                border-bottom: 1px solid var(--glass-border);
            }
            
            .info-panel {
                order: 1;
                padding: 30px 20px;
                min-height: auto;
            }
            
            .main-heading {
                font-size: 3.2rem;
            }
            
            .features-grid {
                grid-template-columns: 1fr;
                gap: 20px;
                max-width: 420px;
            }
            
            .m2store-logo img {
                width: 200px;
            }
        }
        
        @media (max-width: 480px) {
            .main-heading {
                font-size: 2.8rem;
            }
            
            .form-title h1 {
                font-size: 2rem;
            }
            
            .auth-panel, .info-panel {
                padding: 25px 15px;
            }
            
            .m2store-logo img {
                width: 160px;
            }
            
            .feature-card {
                padding: 28px 18px;
                min-height: 130px;
            }
        }
        
        /* ========================================
   كود الموبايل الكامل - النص المتحرك + تسجيل الدخول
   ======================================== */

@media (max-width: 768px) {
    /* إعداد الصفحة الأساسي */
    body, html {
        margin: 0 !important;
        padding: 0 !important;
        height: 100% !important;
        overflow-x: hidden !important;
    }

    /* التخطيط الرئيسي - صفين عموديين */
    .main-layout {
        grid-template-columns: 1fr !important;
        grid-template-rows: auto 1fr !important; /* الأول تلقائي، الثاني يملأ الباقي */
        height: 100vh !important;
        min-height: 100vh !important;
        max-height: 100vh !important;
        overflow: hidden !important;
    }
    
    /* ========================================
       الجزء العلوي - النص المتحرك فقط
       ======================================== */
    .info-panel {
        order: 1 !important;
        padding: 20px 15px 10px !important; /* مساحة صغيرة جداً */
        min-height: auto !important;
        height: auto !important;
        display: flex !important;
        flex-direction: column !important;
        justify-content: center !important;
        align-items: center !important;
        text-align: center;
        background: transparent !important;
    }
    
    /* إخفاء كل شيء عدا النص المتحرك */
    .features-grid,
    .additional-info,
    .sub-heading {
        display: none !important;
    }
    
    /* النص المتحرك \"M2Store\" فقط */
    .main-heading {
        font-size: 2.2rem !important;
        margin-bottom: 0 !important;
        margin-top: 0 !important;
        padding: 0 !important;
    }
    
    /* ========================================
       الجزء السفلي - تسجيل الدخول
       ======================================== */
    .auth-panel {
        order: 2 !important;
        width: 100% !important;
        height: 100% !important; /* يملأ المساحة المتبقية */
        display: flex !important;
        flex-direction: column !important;
        justify-content: flex-start !important; /* البداية من الأعلى */
        align-items: center !important;
        padding: 0 15px 20px !important; /* بدون padding علوي */
        border: none !important;
        overflow-y: auto !important;
        box-sizing: border-box !important;
    }
    
    /* حاوية المحتوى */
    .auth-container {
        width: 100% !important;
        max-width: 400px !important;
        display: flex !important;
        flex-direction: column !important;
        justify-content: flex-start !important; /* البداية من الأعلى */
        align-items: center !important;
        padding-top: 0 !important; /* إزالة أي padding علوي */
        margin-top: 0 !important; /* إزالة أي margin علوي */
    }
    
    /* ========================================
       اللوجو - بدون أي مساحة علوية
       ======================================== */
    .m2store-logo {
        margin-top: 0 !important; /* إزالة المساحة العلوية تماماً */
        margin-bottom: 15px !important;
        padding-top: 0 !important;
    }
    
    .m2store-logo img {
        width: 160px !important;
        height: auto !important;
    }
    
    /* ========================================
       عنوان النموذج
       ======================================== */
    .form-title {
        margin-bottom: 20px !important;
        margin-top: 0 !important;
    }
    
    .form-title h1 {
        font-size: 1.7rem !important;
        margin-bottom: 5px !important;
        margin-top: 0 !important;
    }
    
    .form-title p {
        font-size: 0.9rem !important;
        margin-top: 0 !important;
        margin-bottom: 0 !important;
    }
    
    /* ========================================
       حقول النموذج
       ======================================== */
    .form-group {
        margin-bottom: 15px !important;
        width: 100% !important;
    }
    
    .input-wrapper {
        height: 50px !important;
        width: 100% !important;
    }
    
    .form-control {
        padding: 12px 45px 12px 15px !important;
        font-size: 14px !important;
        height: 50px !important;
        width: 100% !important;
    }
    
    .input-icon {
        right: 15px !important;
        width: 18px !important;
        height: 18px !important;
    }
    
    /* ========================================
       زر تسجيل الدخول
       ======================================== */
    .btn-primary {
        padding: 12px 20px !important;
        font-size: 14px !important;
        margin-bottom: 15px !important;
        width: 100% !important;
        height: 50px !important;
    }
    
    /* ========================================
       رابط نسيان كلمة المرور
       ======================================== */
    .forgot-link {
        margin-top: 10px !important;
        margin-bottom: 0 !important;
    }
    
    .forgot-link a {
        font-size: 13px !important;
    }
}

/* ========================================
   للشاشات الصغيرة جداً (أقل من 480px)
   ======================================== */
@media (max-width: 480px) {
    /* تقليل النص المتحرك أكثر */
    .main-heading {
        font-size: 2rem !important;
    }
    
    /* تقليل اللوجو أكثر */
    .m2store-logo img {
        width: 140px !important;
    }
    
    /* تقليل عنوان النموذج */
    .form-title h1 {
        font-size: 1.5rem !important;
    }
    
    .form-title p {
        font-size: 0.85rem !important;
    }
    
    /* تقليل padding الجانبي */
    .auth-panel {
        padding: 0 10px 15px !important;
    }
    
    .info-panel {
        padding: 15px 10px 8px !important;
    }
}

/* ========================================
   للشاشات القصيرة (Landscape Mode)
   ======================================== */
@media (max-width: 768px) and (max-height: 600px) {
    /* تقليل الأحجام في الوضع الأفقي */
    .main-heading {
        font-size: 1.8rem !important;
    }
    
    .m2store-logo img {
        width: 120px !important;
    }
    
    .m2store-logo {
        margin-bottom: 10px !important;
    }
    
    .form-title h1 {
        font-size: 1.4rem !important;
        margin-bottom: 3px !important;
    }
    
    .form-title p {
        font-size: 0.8rem !important;
    }
    
    .form-title {
        margin-bottom: 15px !important;
    }
    
    .form-group {
        margin-bottom: 12px !important;
    }
    
    .info-panel {
        padding: 12px 15px 5px !important;
    }
}

/* ========================================
   للشاشات العريضة في الموبايل (أكبر من 480px وأقل من 768px)
   ======================================== */
@media (min-width: 481px) and (max-width: 767px) {
    .m2store-logo img {
        width: 180px !important;
    }
    
    .form-title h1 {
        font-size: 1.8rem !important;
    }
    
    .main-heading {
        font-size: 2.4rem !important;
    }

        
    </style>
  </head>
  <body>

    ";
        // line 921
        if (($context["lock"] ?? null)) {
            // line 922
            echo "    <div class=\"lock-screen\" style=\"z-index: 3000;\">
      <div class=\"lock-container\">
        ";
            // line 924
            if ((0 === twig_compare(twig_get_attribute($this->env, $this->source, ($context["lock"] ?? null), "antonio_lock_type", [], "any", false, false, false, 924), "Pattern"))) {
                // line 925
                echo "          <div class=\"lock-brand\">
            <img src=\"view/image/antonio/245.gif\" id=\"antonio_Logo\" alt=\"Logo\"/>
          </div>
          <div class=\"lock-error unauth\" style=\"display: none;\"></div>
          <div class=\"lock-title\">ارسم النمط لإلغاء القفل الآمن</div>
          <div id=\"pattern-block\"></div>
          <input type=\"hidden\" name=\"form_data[pattern_code]\" value=\"\" id=\"input-pattern-code\" class=\"patterncode\"/>
          
        ";
            } elseif ((0 === twig_compare(twig_get_attribute($this->env, $this->source,             // line 933
($context["lock"] ?? null), "antonio_lock_type", [], "any", false, false, false, 933), "Pin"))) {
                // line 934
                echo "          <div class=\"lock-brand\">
            <img src=\"view/image/antonio/245.gif\" alt=\"Logo\"/>
          </div>
          <div class=\"lock-error unauth\" style=\"display: none;\"></div>
          <div class=\"lock-title\">يرجى إدخال الرقم السري المكون من 4 أرقام</div>
          <input type=\"text\" id=\"demo\" style=\"display: none;\">
          
        ";
            }
            // line 942
            echo "        
        <div style=\"margin-top: 25px;\">
          <p style=\"color: var(--text-secondary); margin-bottom: 16px; font-weight: 500;\">
            في المكان الخطأ؟ لا مشكلة!
          </p>
          <button class=\"shopping-button\" onclick=\"window.location.href='";
            // line 947
            echo ($context["HTTP_CATALOG"] ?? null);
            echo "'\">
            🛍️ متابعة التسوق
          </button>
        </div>
      </div>
    </div>
    ";
        }
        // line 954
        echo "
    <div class=\"advanced-background\">
      <!-- الطبقات المتحركة -->
      <div class=\"floating-layers\">
        <div class=\"layer\"></div>
        <div class=\"layer\"></div>
        <div class=\"layer\"></div>
      </div>
      
      <!-- شبكة الأيقونات -->
      <div class=\"icon-network\">
        <!-- أيقونة سلة التسوق -->
        <div class=\"network-node\">
          <svg viewBox=\"0 0 24 24\">
            <path d=\"M7 4V2C7 1.45 7.45 1 8 1H16C16.55 1 17 1.45 17 2V4H20C20.55 4 21 4.45 21 5S20.55 6 20 6H19V19C19 20.1 18.1 21 17 21H7C5.9 21 5 20.1 5 19V6H4C3.45 6 3 5.55 3 5S3.45 4 4 4H7ZM9 3V4H15V3H9ZM7 6V19H17V6H7Z\"/>
          </svg>
        </div>
        
        <!-- أيقونة الفواتير -->
        <div class=\"network-node\">
          <svg viewBox=\"0 0 24 24\">
            <path d=\"M14,2H6A2,2 0 0,0 4,4V20A2,2 0 0,0 6,22H18A2,2 0 0,0 20,20V8L14,2M18,20H6V4H13V9H18V20Z\"/>
          </svg>
        </div>
        
        <!-- أيقونة المنتجات -->
        <div class=\"network-node\">
          <svg viewBox=\"0 0 24 24\">
            <path d=\"M12,2A3,3 0 0,1 15,5V7H20A1,1 0 0,1 21,8V19A3,3 0 0,1 18,22H6A3,3 0 0,1 3,19V8A1,1 0 0,1 4,7H9V5A3,3 0 0,1 12,2M12,4A1,1 0 0,0 11,5V7H13V5A1,1 0 0,0 12,4M5,9V19A1,1 0 0,0 6,20H18A1,1 0 0,0 19,19V9H5Z\"/>
          </svg>
        </div>
        
        <!-- أيقونة الإحصائيات -->
        <div class=\"network-node\">
          <svg viewBox=\"0 0 24 24\">
            <path d=\"M22,21H2V3H4V19H6V10H10V19H12V6H16V19H18V14H22V21Z\"/>
          </svg>
        </div>
        
        <!-- أيقونة العملاء -->
        <div class=\"network-node\">
          <svg viewBox=\"0 0 24 24\">
            <path d=\"M16 4C16.88 4 17.67 4.25 18.31 4.69C17.5 5.26 17 6.09 17 7C17 8.66 18.34 10 20 10C20.34 10 20.66 9.95 20.95 9.85C21 9.23 21 8.61 21 8C21 5.79 19.21 4 17 4H16M9 6C10.66 6 12 7.34 12 9S10.66 12 9 12 6 10.66 6 9 7.34 6 9 6M9 4C6.79 4 5 5.79 5 8S6.79 12 9 12 13 10.21 13 8 11.21 4 9 4M9 13C6.67 13 2 14.17 2 16.5V19H16V16.5C16 14.17 11.33 13 9 13Z\"/>
          </svg>
        </div>
        
        <!-- أيقونة الطلبات -->
        <div class=\"network-node\">
          <svg viewBox=\"0 0 24 24\">
            <path d=\"M3,4A2,2 0 0,0 1,6V17H3A3,3 0 0,0 6,20A3,3 0 0,0 9,17H15A3,3 0 0,0 18,20A3,3 0 0,0 21,17H23V12L20,8H17V4M10,6L14,10L10,14V11H4V9H10M17,9.5H19.5L21.47,12H17M6,15.5A1.5,1.5 0 0,1 7.5,17A1.5,1.5 0 0,1 6,18.5A1.5,1.5 0 0,1 4.5,17A1.5,1.5 0 0,1 6,15.5M18,15.5A1.5,1.5 0 0,1 19.5,17A1.5,1.5 0 0,1 18,18.5A1.5,1.5 0 0,1 16.5,17A1.5,1.5 0 0,1 18,15.5Z\"/>
          </svg>
        </div>
        
        <!-- أيقونة المدفوعات -->
        <div class=\"network-node\">
          <svg viewBox=\"0 0 24 24\">
            <path d=\"M20,8H4V6H20M20,18H4V12H20M20,4H4C2.89,4 2,4.89 2,6V18A2,2 0 0,0 4,20H20A2,2 0 0,0 22,18V6C22,4.89 21.1,4 20,4Z\"/>
          </svg>
        </div>
        
        <!-- أيقونة التقارير -->
        <div class=\"network-node\">
          <svg viewBox=\"0 0 24 24\">
            <path d=\"M13,9H18.5L13,3.5V9M6,2H14L20,8V20A2,2 0 0,1 18,22H6C4.89,22 4,21.1 4,20V4C4,2.89 4.89,2 6,2M15,18V16H6V18H15M18,14V12H6V14H18Z\"/>
          </svg>
        </div>
        
        <!-- أيقونة المخزون -->
        <div class=\"network-node\">
          <svg viewBox=\"0 0 24 24\">
            <path d=\"M12,3L2,12H5V20H19V12H22L12,3M12,8.75A2.25,2.25 0 0,1 14.25,11A2.25,2.25 0 0,1 12,13.25A2.25,2.25 0 0,1 9.75,11A2.25,2.25 0 0,1 12,8.75M12,15C13.5,15 16.5,15.75 16.5,17.25V18H7.5V17.25C7.5,15.75 10.5,15 12,15Z\"/>
          </svg>
        </div>
        
        <!-- أيقونة الخصومات -->
        <div class=\"network-node\">
          <svg viewBox=\"0 0 24 24\">
            <path d=\"M12.79,21L3,11.21V2H11.21L21,11.79M5.5,4A1.5,1.5 0 0,1 7,5.5A1.5,1.5 0 0,1 5.5,7A1.5,1.5 0 0,1 4,5.5A1.5,1.5 0 0,1 5.5,4Z\"/>
          </svg>
        </div>
      </div>
    </div>
    
    <div class=\"main-layout\">
      <!-- قسم تسجيل الدخول - يمين - 30% -->
      <div class=\"auth-panel\">
        <div class=\"auth-container\">
          <div class=\"m2store-logo\">
            <img src=\"view/image/antonio/adminpro_logo.png\" id=\"antonio_Logo1\" alt=\"شعار M2Store\">
          </div>
          
          <div class=\"form-title\">
            <h1>أهلاً وسهلاً</h1>
            <p>قم بتسجيل الدخول إلى لوحة التحكم الخاصة بك</p>
          </div>

          <!-- رسائل الخطأ/النجاح OpenCart Standard -->
          ";
        // line 1051
        if (($context["error_warning"] ?? null)) {
            // line 1052
            echo "          <div class=\"alert alert-danger\">
            <i class=\"fa fa-exclamation-circle\"></i> ";
            // line 1053
            echo ($context["error_warning"] ?? null);
            echo "
          </div>
          ";
        }
        // line 1056
        echo "
          ";
        // line 1057
        if (($context["success"] ?? null)) {
            // line 1058
            echo "          <div class=\"alert alert-success\">
            <i class=\"fa fa-check-circle\"></i> ";
            // line 1059
            echo ($context["success"] ?? null);
            echo "
          </div>
          ";
        }
        // line 1062
        echo "          
          <!-- **نموذج تسجيل الدخول OpenCart الأساسي** -->
          <form action=\"";
        // line 1064
        echo ($context["action"] ?? null);
        echo "\" method=\"post\" enctype=\"multipart/form-data\" role=\"form\">
            <div class=\"form-group\">
              <div class=\"input-wrapper\">
                <svg class=\"input-icon\" viewBox=\"0 0 24 24\">
                  <path d=\"M12,4A4,4 0 0,1 16,8A4,4 0 0,1 12,12A4,4 0 0,1 8,8A4,4 0 0,1 12,4M12,14C16.42,14 20,15.79 20,18V20H4V18C4,15.79 7.58,14 12,14Z\"/>
                </svg>
                <input
                  type=\"text\"
                  name=\"username\"
                  value=\"";
        // line 1073
        echo ($context["username"] ?? null);
        echo "\"
                  placeholder=\"";
        // line 1074
        echo ($context["entry_username"] ?? null);
        echo "\"
                  id=\"input-username\"
                  class=\"form-control\"
                  autocomplete=\"username\"
                  required
                />
              </div>
            </div>
            
            <div class=\"form-group\">
              <div class=\"input-wrapper\">
                <svg class=\"input-icon\" viewBox=\"0 0 24 24\">
                  <path d=\"M12,17A2,2 0 0,0 14,15C14,13.89 13.1,13 12,13A2,2 0 0,0 10,15A2,2 0 0,0 12,17M18,8A2,2 0 0,1 20,10V20A2,2 0 0,1 18,22H6A2,2 0 0,1 4,20V10C4,8.89 4.9,8 6,8H7V6A5,5 0 0,1 12,1A5,5 0 0,1 17,6V8H18M12,3A3,3 0 0,0 9,6V8H15V6A3,3 0 0,0 12,3Z\"/>
                </svg>
                <input
                  type=\"password\"
                  name=\"password\"
                  value=\"";
        // line 1091
        echo ($context["password"] ?? null);
        echo "\"
                  placeholder=\"";
        // line 1092
        echo ($context["entry_password"] ?? null);
        echo "\"
                  id=\"input-password\"
                  class=\"form-control\"
                  autocomplete=\"current-password\"
                  required
                />
              </div>
            </div>
            
            <div class=\"form-group\">
              <button type=\"submit\" class=\"btn btn-primary\">
                ";
        // line 1103
        echo ($context["button_login"] ?? null);
        echo "
              </button>
            </div>

            <!-- OpenCart Standard Fields -->
            ";
        // line 1108
        if (($context["redirect"] ?? null)) {
            // line 1109
            echo "            <input type=\"hidden\" name=\"redirect\" value=\"";
            echo ($context["redirect"] ?? null);
            echo "\" />
            ";
        }
        // line 1111
        echo "
            <!-- CSRF Token if exists -->
            ";
        // line 1113
        if (($context["csrf_token"] ?? null)) {
            // line 1114
            echo "            <input type=\"hidden\" name=\"csrf_token\" value=\"";
            echo ($context["csrf_token"] ?? null);
            echo "\" />
            ";
        }
        // line 1116
        echo "          </form>
          
          <div class=\"forgot-link\">
            <a href=\"";
        // line 1119
        echo ($context["forgotten"] ?? null);
        echo "\">نسيت كلمة المرور؟</a>
          </div>
        </div>
      </div>
      
      <!-- قسم المعلومات - يسار - 70% -->
      <div class=\"info-panel\">
        <div class=\"info-content\">
          <h1 class=\"main-heading element dynamic-text\">M2Store</h1>
          <p class=\"sub-heading dynamic-text\">منصة إدارة المتاجر الإلكترونية الأكثر تطوراً في الشرق الأوسط</p>
          
          <div class=\"features-grid\">
            <div class=\"feature-card\">
              <div class=\"feature-icon-wrapper\">
                <svg class=\"feature-icon\" viewBox=\"0 0 24 24\">
                  <path d=\"M12,2A3,3 0 0,1 15,5V7H20A1,1 0 0,1 21,8V19A3,3 0 0,1 18,22H6A3,3 0 0,1 3,19V8A1,1 0 0,1 4,7H9V5A3,3 0 0,1 12,2M12,4A1,1 0 0,0 11,5V7H13V5A1,1 0 0,0 12,4M5,9V19A1,1 0 0,0 6,20H18A1,1 0 0,0 19,19V9H5Z\"/>
                </svg>
              </div>
              <span class=\"feature-text\">إدارة المنتجات الذكية</span>
              <span class=\"feature-description\">نظام متطور لإدارة وتنظيم المنتجات</span>
            </div>
            
            <div class=\"feature-card\">
              <div class=\"feature-icon-wrapper\">
                <svg class=\"feature-icon\" viewBox=\"0 0 24 24\">
                  <path d=\"M14,2H6A2,2 0 0,0 4,4V20A2,2 0 0,0 6,22H18A2,2 0 0,0 20,20V8L14,2M18,20H6V4H13V9H18V20Z\"/>
                </svg>
              </div>
              <span class=\"feature-text\">نظام الفوترة المتقدم</span>
              <span class=\"feature-description\">إنشاء وإدارة الفواتير بسهولة</span>
            </div>
            
            <div class=\"feature-card\">
              <div class=\"feature-icon-wrapper\">
                <svg class=\"feature-icon\" viewBox=\"0 0 24 24\">
                  <path d=\"M22,21H2V3H4V19H6V10H10V19H12V6H16V19H18V14H22V21Z\"/>
                </svg>
              </div>
              <span class=\"feature-text\">تحليلات وتقارير شاملة</span>
              <span class=\"feature-description\">رؤى عميقة لأداء متجرك</span>
            </div>
            
            <div class=\"feature-card\">
              <div class=\"feature-icon-wrapper\">
                <svg class=\"feature-icon\" viewBox=\"0 0 24 24\">
                  <path d=\"M12 12C14.21 12 16 10.21 16 8S14.21 4 12 4 8 5.79 8 8 9.79 12 12 12M12 14C9.33 14 4 15.34 4 18V20H20V18C20 15.34 14.67 14 12 14Z\"/>
                </svg>
              </div>
              <span class=\"feature-text\">إدارة العملاء المحترفة</span>
              <span class=\"feature-description\">قاعدة بيانات متطورة للعملاء</span>
            </div>
          </div>
          
          <div class=\"additional-info\">
            <p class=\"help-text dynamic-text\">تحتاج إلى مساعدة أو دعم فني؟</p>
            <a href=\"https://m2.ist/contact.html\" target=\"_blank\" class=\"contact-link\">
              تواصل مع فريق الدعم ←
            </a>
          </div>
        </div>
      </div>
    </div>

    <script src=\"view/javascript/output.min.js\"></script>

    <script>
      (function (\$) {
        \"use strict\";

        // تأثير الكتابة
        try{
          if(\$('.unauth').length > 0){
            var typed2 = new Typed(\".unauth\", {
              strings: [
                \"⚠️ وصول غير مصرح به\",
                \"🔒 UNAUTHORIZED ACCESS\"
              ],
              backSpeed: 80,
              typeSpeed: 100,
              loop: false,
              showCursor: false
            });
          }
        }catch(err){
          console.log('Lock is not Enabled!')
        }

        // تأثير الكتابة للعنوان الرئيسي
        const getWelcometext = \"";
        // line 1207
        echo twig_get_attribute($this->env, $this->source, ($context["lock"] ?? null), "module_antonio_anim_text1", [], "any", false, false, false, 1207);
        echo "\";
        let welcomeStrings;
        
        if('";
        // line 1210
        echo twig_get_attribute($this->env, $this->source, ($context["lock"] ?? null), "module_antonio_anim_text1", [], "any", false, false, false, 1210);
        echo "'){
          welcomeStrings = [getWelcometext];
        } else {
          welcomeStrings = [
            \"M2Store 🏪\",
            \"الإصدار 2.0 ✨\", 
            \"نظام متطور 🚀\",
            \"إدارة احترافية 💼\",
            \"تجربة استثنائية 🌟\"
          ];
        }

        var typed = new Typed(\".element\", {
          strings: welcomeStrings,
          typeSpeed: 45,
          backSpeed: 25,
          smartBackspace: true,
          loop: true,
          showCursor: false,
          fadeOut: true,
          fadeOutClass: 'typed-fade-out',
          fadeOutDelay: 150,
          backDelay: 1000,
          startDelay: 200,
        });

        // تحسينات تفاعلية للنموذج - لا تتداخل مع الإرسال
        \$('.form-control').on('focus', function(){
          \$(this).closest('.input-wrapper').addClass('focused');
          \$(this).closest('.input-wrapper').find('.input-icon').addClass('active');
        });
        
        \$('.form-control').on('blur', function(){
          if(\$(this).val() === '') {
            \$(this).closest('.input-wrapper').removeClass('focused');
            \$(this).closest('.input-wrapper').find('.input-icon').removeClass('active');
          }
        });

        // أنظمة القفل
        if('";
        // line 1250
        echo twig_get_attribute($this->env, $this->source, ($context["lock"] ?? null), "antonio_lock_type", [], "any", false, false, false, 1250);
        echo "'=='Pattern'){
          var lock = new PatternLock(\"#pattern-block\", {
            matrix: [3,3],
            margin: 15,
            radius: 25,
            delimiter: ',',
            onDraw:function(pattern) {
              checkPattern(pattern);
            },
            enableSetPattern: true
          });
        }

        function checkPattern(pattern){
          \$.post(\"../index.php?route=extension/account/antonio/api/antoniolockrest/get_plocker\",
            {
              name: pattern
            },
            function(data, status){
              if(data=='true'){
                \$('.lock-screen').fadeOut(800, 'swing');
              }else{
                showLockError();
              }
            });
        }

        \$('#demo').pincodeInput({
          inputs: 4,        
          hideDigits: true,             
          keydown: function(e){},
          placeholders: \"● ● ● ●\",
          change: function(input, value, inputnumber){
            \$(input).addClass('pin-active');
            setTimeout(() => {
              \$(input).removeClass('pin-active');
            }, 300);
          },
          complete: function(value, e, errorElement){
            checkPin(value);
          }
        });

        function checkPin(pin){
          \$.post(\"../index.php?route=extension/account/antonio/api/antoniolockrest/get_pinlocker\",
            {
              name: pin
            },
            function(data, status){
              if(data=='true'){
                \$('.lock-screen').fadeOut(800, 'swing');
              }else{
                showLockError();
              }
            });
        }

        function showLockError(){
          \$('.lock-error').show().addClass('error-pulse');
          setTimeout(() => {
            \$('.lock-error').removeClass('error-pulse');
          }, 800);
        }

        setTimeout(function(){ 
          \$('.pincode-input-container input:first').focus(); 
        }, 200);

        // معلومات المطور
        function Person(Name, Version, Publisher, Author, Design) {
          this.Name = Name;
          this.Version = Version;
          this.Publisher = Publisher;
          this.Author = Author;
          this.Design = Design;
        }
        var me = new Person(\"Antonio RTL OpenCart Integration\", \"2.5\", \"Adpro Infotech\", \"Prosenjeet Paul\", \"Login System Fixed\");
        console.table(me);

      })(jQuery);
    </script>
    
  </body>
</html>
";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName()
    {
        return "extension/theme/antonio/antonio.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable()
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo()
    {
        return array (  1361 => 1250,  1318 => 1210,  1312 => 1207,  1221 => 1119,  1216 => 1116,  1210 => 1114,  1208 => 1113,  1204 => 1111,  1198 => 1109,  1196 => 1108,  1188 => 1103,  1174 => 1092,  1170 => 1091,  1150 => 1074,  1146 => 1073,  1134 => 1064,  1130 => 1062,  1124 => 1059,  1121 => 1058,  1119 => 1057,  1116 => 1056,  1110 => 1053,  1107 => 1052,  1105 => 1051,  1006 => 954,  996 => 947,  989 => 942,  979 => 934,  977 => 933,  967 => 925,  965 => 924,  961 => 922,  959 => 921,  37 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("", "extension/theme/antonio/antonio.twig", "");
    }
}
