<?php
class ControllerProductCategory extends Controller {
	public function index() {

        // path manager - preserve bc
        if (isset($this->request->get['path']) && $this->config->get('mlseo_fpp_directcat')) {
          $cat_id = strrchr('_'.$this->request->get['path'], '_');
          $cat_id = str_replace('_', '', $cat_id);
          $this->load->model('tool/path_manager');
          $this->request->get['path'] = $this->model_tool_path_manager->getFullCategoryPath($cat_id);
        }
        
        $seoPageName = $this->config->get('mlseo_pagination_name_'.$this->config->get('config_language_id')) != 'mlseo_pagination_name_'.$this->config->get('config_language_id') ? $this->config->get('mlseo_pagination_name_'.$this->config->get('config_language_id')) : 'page';
      
		$this->load->language('product/category');

		$this->load->model('catalog/category');

		$this->load->model('catalog/product');

		$this->load->model('tool/image');

		if (isset($this->request->get['filter'])) {
			$filter = $this->request->get['filter'];
		} else {
			$filter = '';
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'p.sort_order';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = (int)$this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['limit']) && (int)$this->request->get['limit'] > 0) {
			$limit = (int)$this->request->get['limit'];
		} else {
			$limit = $this->config->get('theme_' . $this->config->get('config_theme') . '_product_limit');
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);

		if (isset($this->request->get['path'])) {
			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$path = '';

			$parts = explode('_', (string)$this->request->get['path']);

			$category_id = (int)array_pop($parts);

			foreach ($parts as $path_id) {
				if (!$path) {
					$path = (int)$path_id;
				} else {
					$path .= '_' . (int)$path_id;
				}

				$category_info = $this->model_catalog_category->getCategory($path_id);

				if ($category_info) {
					$data['breadcrumbs'][] = array(
						'text' => $category_info['name'],
						'href' => $this->url->link('product/category', 'path=' . $path . $url)
					);
				}
			}
		} else {
			$category_id = 0;
		}

		$category_info = $this->model_catalog_category->getCategory($category_id);

		if ($category_info) {
			$this->document->setTitle(!empty($category_info['meta_title']) && $this->config->get('mlseo_enabled') ? $category_info['meta_title'] . ((!empty($seoPageName) && !empty($this->request->get['page'])) ? ' - ' . $seoPageName . ' ' . $this->request->get['page'] : '') : $category_info['name']);
			$this->document->setDescription($category_info['meta_description'] . (!empty($this->request->get['page']) ? ' - ' . $seoPageName . ' ' . $this->request->get['page'] : ''));
			$this->document->setKeywords($category_info['meta_keyword']);

			
      //$data['heading_title'] = $category_info['name'];
      
      $data["heading_title"] = !empty($category_info['seo_h1']) && $this->config->get('mlseo_enabled') ? $category_info['seo_h1'] : $category_info['name'];
      $data["heading_title"] .= (!empty($seoPageName) && !empty($this->request->get['page'])) ? ' - ' . $seoPageName . ' ' . $this->request->get['page'] : '';
      
      $data['seo_h1'] = !empty($category_info['seo_h1']) ? $category_info['seo_h1'] : '';
      $data['seo_h2'] = !empty($category_info['seo_h2']) ? $category_info['seo_h2'] : '';
      $data['seo_h3'] = !empty($category_info['seo_h3']) ? $category_info['seo_h3'] : '';

      if (!empty($category_info['meta_robots'])) {
        $this->document->addSeoMeta('<meta name="robots" content="'.$category_info['meta_robots'].'"/>'."\n");
      }
      
      if ($this->config->get('mlseo_enabled')) {
        $this->load->model('tool/seo_package');
        
        if ($this->config->get('mlseo_microdata')) {
          $this->document->addSeoMeta($this->model_tool_seo_package->rich_snippet('microdata', 'category', $data));
        }
      }
      
      if ($this->config->get('mlseo_header_lm_category')) {
        $gkd_header_lm_date = strtotime($category_info['date_modified']);
        
        $this->response->addHeader('Last-Modified: '.date('D, d M Y H:i:s', $gkd_header_lm_date).' GMT');
      }
      

			$data['text_compare'] = sprintf($this->language->get('text_compare'), (isset($this->session->data['compare']) ? count($this->session->data['compare']) : 0));

			// Set the last category breadcrumb
			$data['breadcrumbs'][] = array(
				'text' => $category_info['name'],
				'href' => $this->url->link('product/category', 'path=' . $this->request->get['path'])
			);


      if (!empty($this->request->get['page'])) {
        $data['breadcrumbs'][] = array(
          'text' => $category_info['name'] . (!empty($this->request->get['page']) ? ' - ' . $seoPageName . ' ' . $this->request->get['page'] : ''),
          'href' => $this->config->get('config_url').(isset($_GET['_route_']) ? $_GET['_route_'] : '')
        );
      }
      
			if ($category_info['image']) {
				$data['thumb'] = $this->model_tool_image->resize($category_info['image'], $this->config->get('theme_' . $this->config->get('config_theme') . '_image_category_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_category_height'));
			} else {
				$data['thumb'] = '';
			}

			$data['description'] = html_entity_decode($category_info['description'], ENT_QUOTES, 'UTF-8');

      $seoHeadings = $this->config->get('mlseo_headings');
      
      if ($this->config->get('mlseo_enabled')) {
        $extraTopDesc = $extraBottomDesc = '';
        
        foreach (array('h1', 'h2', 'h3') as $headingType) {
          if (!empty($seoHeadings['category'][$headingType]['pos']) && !empty($category_info['seo_'.$headingType]) && $seoHeadings['category'][$headingType]['pos'] == 'topdesc') {
            $extraTopDesc .= '<'.$headingType.' class="seo_'.$headingType.'"'.(!empty($seoHeadings['category'][$headingType]['css']) ? ' style="'.$seoHeadings['category'][$headingType]['css'].'"' : '').'>'.$category_info['seo_'.$headingType].'</'.$headingType.'>';
          }
          
          if (!empty($seoHeadings['category'][$headingType]['pos']) && !empty($category_info['seo_'.$headingType]) && $seoHeadings['category'][$headingType]['pos'] == 'botdesc') {
            $extraBottomDesc .= '<'.$headingType.' class="seo_'.$headingType.'"'.(!empty($seoHeadings['category'][$headingType]['css']) ? ' style="'.$seoHeadings['category'][$headingType]['css'].'"' : '').'>'.$category_info['seo_'.$headingType].'</'.$headingType.'>';
          }
        }
        
        if ($this->config->get('mlseo_autolink')) {
          $autolinks = $this->db->query("SELECT * FROM " . DB_PREFIX . "url_autolink WHERE language_id =  '". (int) $this->config->get('config_language_id') . "'")->rows;
          
          foreach ($autolinks as $autolink) {
            $data['description'] = preg_replace('/<a\b[^>]*>[^<]*<\/a>(*SKIP)(*FAIL)|\b('.$autolink['query'].')\b/u', '<a href="'.$autolink['redirect'].'">$1</a>', $data['description']);
          }
        }
        
        $data['description'] = $extraTopDesc . $data['description'] . $extraBottomDesc;
      }
      
			$data['compare'] = $this->url->link('product/compare');

			$url = '';

			if (isset($this->request->get['filter'])) {
				$url .= '&filter=' . $this->request->get['filter'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$data['categories'] = array();

			$results = $this->model_catalog_category->getCategories($category_id);

			foreach ($results as $result) {
				$filter_data = array(
					'filter_category_id'  => $result['category_id'],
					'filter_sub_category' => true
				);

				$data['categories'][] = array(
					'name' => $result['name'] . ($this->config->get('config_product_count') ? ' (' . $this->model_catalog_product->getTotalProducts($filter_data) . ')' : ''),
					'href' => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '_' . $result['category_id'] . $url)
				);
			}

			$data['products'] = array();

			$filter_data = array(
				'filter_category_id' => $category_id,
				'filter_filter'      => $filter,
				'sort'               => $sort,
				'order'              => $order,
				'start'              => ($page - 1) * $limit,
				'limit'              => $limit
			);

			$product_total = $this->model_catalog_product->getTotalProducts($filter_data);

			$results = $this->model_catalog_product->getProducts($filter_data);

      	/* GKD schema itemList */
        $richSnippetsConfig = $this->config->get('mlseo_microdata_data');
        
        if (!empty($richSnippetsConfig['category']) && !empty($richSnippetsConfig['itemList'])) {
          $best_rating = $review_total = 0;
          $includeItemList = true;
          $itemListElement = array();
          
          $i = 0;
          
          foreach ($results as $product) {
            $review_total += $product['rating'];
            $best_rating = ($product['rating'] > $best_rating) ? $product['rating'] : $best_rating;
           
            if ($includeItemList && $i <= 20) {
              $currentItem = array();
              $currentItem['@context'] = 'http://schema.org';
              $currentItem['@type'] = 'Product';
              $currentItem['url'] = $this->url->link('product/product', 'product_id='.$product['product_id']);
              //alex we need h1 NAME HERE not meta_title
              $currentItem['name'] = !empty($product['seo_h1']) ? html_entity_decode($product['seo_h1'], ENT_QUOTES, 'UTF-8') : html_entity_decode($product['name'], ENT_QUOTES, 'UTF-8');
              $currentItem['image'] = $this->model_tool_image->resize($product['image'], $this->config->get('theme_' . $this->config->get('config_theme') . '_image_category_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_category_height') ); 
              
              $has_idtentifier = false;
              
              if (!empty($config['model'])) {
                $currentItem['model'] = $product['model'];
              }
              
              if (!empty($config['mpn']) && !empty($product['mpn'])) {
                $currentItem['mpn'] = $product['mpn'];
                $has_idtentifier = true;
              }
              
              if (!empty($config['sku'])) {
                $currentItem['sku'] = !empty($product['sku']) ? $product['sku'] : $product['model'];
              }
              
              if (!empty($config['upc']) && !empty($data['product_info']['upc'])) {
                $currentItem['gtin12'] = $product['upc'];
                $currentItem['gtin'] = $dproduct['upc'];
                $has_idtentifier = true;
              } else if (!empty($config['ean']) && !empty($product['ean'])) {
                $currentItem['gtin'] = $product['ean'];
                $currentItem['gtin8'] = $product['ean'];
                $has_idtentifier = true;
              } else if (!empty($config['jan']) && !empty($product['jan'])) {
                $currentItem['gtin'] = $product['jan'];
                $has_idtentifier = true;
              } else if (!empty($config['isbn']) && !empty($product['isbn'])) {
                //$currentItem['gtin13'] = $data['product_info']['isbn'];
                $currentItem['gtin'] = $product['isbn'];
                $currentItem['isbn'] = $product['isbn'];
                $has_idtentifier = true;
              }
              
              if (!empty($config['brand']) && !empty($product['manufacturer'])) {
                $currentItem['manufacturer'] = strip_tags($product['manufacturer']);
                $currentItem['brand'] = array(
                  '@type' => 'Brand',
                  'name' => strip_tags($product['manufacturer']),
                );
              }
              
              if ($product['special']) {
                if (isset($product['special_date_end'])) {
                  $specialQuery = array('date_end' => $product['special_date_end']);
                } else {
                  $specialQuery = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_special ps WHERE ps.product_id = " . (int)$product['product_id'] . " AND ps.customer_group_id = '" . (int)$this->config->get('config_customer_group_id') . "' AND ((ps.date_start = '0000-00-00' OR ps.date_start < NOW()) AND (ps.date_end = '0000-00-00' OR ps.date_end > NOW())) ORDER BY ps.priority ASC, ps.price ASC LIMIT 1")->row;
                }
                 
                $currentItem['offers'] = array(
                  'name' => !empty($product['seo_h1']) ? html_entity_decode($product['seo_h1'], ENT_QUOTES, 'UTF-8') : html_entity_decode($product['name'], ENT_QUOTES, 'UTF-8'),
                  'url' => $currentItem['url'],
                  'price' => $product['special'],
                  'priceCurrency' => $this->config->get('config_currency'),
                  'itemCondition' => 'http://schema.org/NewCondition',
                  'seller' => array(
                    '@type' => 'Organization',
                    'name' => $this->config->get('config_name'),
                  ),
                );
                
                if (isset($specialQuery['date_end']) && $specialQuery['date_end'] != '0000-00-00') {
                $currentItem['offers']['priceValidUntil'] = $specialQuery['date_end'];
                } else {
                $currentItem['offers']['priceValidUntil'] = date('Y-m-d', strtotime('+1 years', strtotime(date("Y-m-d "))));
                }
              } else {
                $currentItem['offers'] = array(
                  'name' => !empty($product['seo_h1']) ? html_entity_decode($product['seo_h1'], ENT_QUOTES, 'UTF-8') : html_entity_decode($product['name'], ENT_QUOTES, 'UTF-8'),
                  'url' => $currentItem['url'],
                  'price' => $product['price'],
                  'priceCurrency' => $this->config->get('config_currency'),
                  'priceValidUntil' => date('Y-m-d', strtotime('+1 years', strtotime(date("Y-m-d ")))),
                  'itemCondition' => 'http://schema.org/NewCondition',
                  'seller' => array(
                    '@type' => 'Organization',
                    'name' => $this->config->get('config_name'),
                  ),
                );
              }
              
              if ($product['quantity'] > 0) {
                //$currentItem['offers']['availability'] = 'https://schema.org/InStock';
                $currentItem['offers']['availability'] = 'InStock';
              } else {
                $stockStatusQuery = $this->db->query("SELECT stock_status_id FROM " . DB_PREFIX . "product WHERE product_id = " . (int)$product['product_id'])->row;
                
                if (!empty($config['order_status'][$stockStatusQuery['stock_status_id']])) {
                //$currentItem['offers']['availability'] = 'https://schema.org/'.$config['order_status'][$stockStatusQuery['stock_status_id']];
                $currentItem['offers']['availability'] = $config['order_status'][$stockStatusQuery['stock_status_id']];
                }
              }
              
              if (!empty($config['reviews'])) {
                $best_rating = $review_total = 0;
                
                // get all reviews
                if (true) {
                $this->load->model('catalog/review');
                $data['reviews'] = $this->model_catalog_review->getReviewsByProductId($product['product_id'], 0, 999999999999);
                }
                
                foreach ($data['reviews'] as $review) {
                $review_total += $review['rating'];
                $best_rating = ($review['rating'] > $best_rating) ? $review['rating'] : $best_rating;
                }
                
                if (count($data['reviews'])) {
                $currentItem['aggregateRating'] = array(
                  '@type' => 'AggregateRating',
                  'ratingValue' => round($review_total / count($data['reviews']), 1),
                  'bestRating' => $best_rating,
                  'reviewCount' => count($data['reviews']),
                );
                }
              }
              
              $jsonProduct = array();
              $jsonProduct['@type'] = 'ListItem';
              $jsonProduct['position'] = $i+1;
              $jsonProduct['item'] = $currentItem;
              $itemListElement[] = $jsonProduct;
            }
            
            $i++;
          }
          
          $output = '';
          
          if ($product_total > 0) {
            $json = array();
            $json['@context'] = 'http://schema.org';
            $json['@type'] = 'ItemList';
            $json['itemListElement'] = $itemListElement;
            $json['numberOfItems'] = $product_total;
            
            $output .= '<script type="application/ld+json">'.json_encode($json).'</script>'."\n";
          }
          
          if ($product_total > 0 && $review_total > 0) {
            $json = array();
            
            $json['aggregateRating'] = array(
            '@type' => 'AggregateRating',
            'ratingValue' => round($review_total / $product_total, 1),
            'bestRating' => $best_rating,
            'reviewCount' => $product_total,
            );
            
            $output .= '<script type="application/ld+json">'.json_encode($json).'</script>'."\n";
          }
          
          $data['description'] .= $output;
        }
				/* GKD schema itemList */
      

			foreach ($results as $result) {
				if ($result['image']) {
					$image = $this->model_tool_image->resize($result['image'], $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_height'));
				} else {
					$image = $this->model_tool_image->resize('placeholder.png', $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_height'));
				}

				if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
					$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
				} else {
					$price = false;
				}

				if (!is_null($result['special']) && (float)$result['special'] >= 0) {
					$special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
					$tax_price = (float)$result['special'];
				} else {
					$special = false;
					$tax_price = (float)$result['price'];
				}
	
				if ($this->config->get('config_tax')) {
					$tax = $this->currency->format($tax_price, $this->session->data['currency']);
				} else {
					$tax = false;
				}

				if ($this->config->get('config_review_status')) {
					$rating = (int)$result['rating'];
				} else {
					$rating = false;
				}

				$data['products'][] = array(
					'product_id'  => $result['product_id'],

        'image_title' => isset($result['image_title']) ? $result['image_title'] : '',
        'image_alt' => isset($result['image_alt']) ? $result['image_alt'] : '',
        
					'thumb'       => $image,
					'name'        => $result['name'],
					'description' => utf8_substr(trim(strip_tags(html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8'))), 0, $this->config->get('theme_' . $this->config->get('config_theme') . '_product_description_length')) . '..',
					'price'       => $price,
					'special'     => $special,
					'tax'         => $tax,
					'minimum'     => $result['minimum'] > 0 ? $result['minimum'] : 1,
					'rating'      => $result['rating'],
					'href'        => $this->url->link('product/product', 'path=' . $this->request->get['path'] . '&product_id=' . $result['product_id'] . $url)
				);
			}

			$url = '';

			if (isset($this->request->get['filter'])) {
				$url .= '&filter=' . $this->request->get['filter'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$data['sorts'] = array();

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_default'),
				'value' => 'p.sort_order-ASC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.sort_order&order=ASC' . $url)
			);

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_name_asc'),
				'value' => 'pd.name-ASC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=pd.name&order=ASC' . $url)
			);

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_name_desc'),
				'value' => 'pd.name-DESC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=pd.name&order=DESC' . $url)
			);

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_price_asc'),
				'value' => 'p.price-ASC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.price&order=ASC' . $url)
			);

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_price_desc'),
				'value' => 'p.price-DESC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.price&order=DESC' . $url)
			);

			if ($this->config->get('config_review_status')) {
				$data['sorts'][] = array(
					'text'  => $this->language->get('text_rating_desc'),
					'value' => 'rating-DESC',
					'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=rating&order=DESC' . $url)
				);

				$data['sorts'][] = array(
					'text'  => $this->language->get('text_rating_asc'),
					'value' => 'rating-ASC',
					'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=rating&order=ASC' . $url)
				);
			}

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_model_asc'),
				'value' => 'p.model-ASC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.model&order=ASC' . $url)
			);

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_model_desc'),
				'value' => 'p.model-DESC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.model&order=DESC' . $url)
			);

			$url = '';

			if (isset($this->request->get['filter'])) {
				$url .= '&filter=' . $this->request->get['filter'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			$data['limits'] = array();

			$limits = array_unique(array($this->config->get('theme_' . $this->config->get('config_theme') . '_product_limit'), 25, 50, 75, 100));

			sort($limits);

			foreach($limits as $value) {
				$data['limits'][] = array(
					'text'  => $value,
					'value' => $value,
					'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . $url . '&limit=' . $value)
				);
			}

			$url = '';

			if (isset($this->request->get['filter'])) {
				$url .= '&filter=' . $this->request->get['filter'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}


        if ($this->config->get('ocme_mfp_license') ) {
          if (isset($this->request->get['ocmef'])) {
            $url .= '&ocmef=' . $this->request->get['ocmef'];
          }
        }
        
			$pagination = new Pagination();
			$pagination->total = $product_total;
			$pagination->page = $page;
			$pagination->limit = $limit;
			$pagination->url = $this->url->link('product/category', 'path=' . $this->request->get['path'] . $url . '&page={page}');

			$data['pagination'] = $pagination->render();

			$data['results'] = sprintf($this->language->get('text_pagination'), ($product_total) ? (($page - 1) * $limit) + 1 : 0, ((($page - 1) * $limit) > ($product_total - $limit)) ? $product_total : ((($page - 1) * $limit) + $limit), $product_total, ceil($product_total / $limit));

			// http://googlewebmastercentral.blogspot.com/2011/09/pagination-with-relnext-and-relprev.html

      if ($page > 1 AND $this->config->get('mlseo_pagination_canonical')) {
         $this->load->model('tool/path_manager'); $this->document->addLink($this->url->link('product/category', 'path=' . ($this->config->get('mlseo_fpp_cat_canonical') ? $this->model_tool_path_manager->getFullCategoryPath($category_info['category_id']) : $category_info['category_id']) . '&page='. $page, true), 'canonical');
      }
      
			if ($page == 1) {
			    
        $this->load->model('tool/path_manager');
        if (empty($this->request->get['mfp_seo_alias'])) {
          $this->document->addLink($this->url->link('product/category', 'path=' . ($this->config->get('mlseo_fpp_cat_canonical') ? $this->model_tool_path_manager->getFullCategoryPath($category_info['category_id']) : $category_info['category_id'])), 'canonical');
        } else {
          $this->document->addLink( rtrim( $this->url->link('product/category', 'path=' . ($this->config->get('mlseo_enabled') && $this->config->get('mlseo_pagination_fix') ? $this->request->get['path'] : $category_info['category_id']), true), '/' ) . '/' . $this->request->get['mfp_seo_alias'], 'canonical');
        }
        
			} else {
				$this->load->model('tool/path_manager'); $this->document->addLink($this->url->link('product/category', 'path=' . ($this->config->get('mlseo_fpp_cat_canonical') ? $this->model_tool_path_manager->getFullCategoryPath($category_info['category_id']) : $category_info['category_id']) . ($this->config->get('mlseo_pagination_canonical') ? '&page='. $page : '')), 'canonical');
			}
			
			if ($page > 1) {
			    $this->load->model('tool/path_manager'); $this->document->addLink($this->url->link('product/category', 'path=' . ($this->config->get('mlseo_fpp_cat_canonical') ? $this->model_tool_path_manager->getFullCategoryPath($category_info['category_id']) : $category_info['category_id']) . (($page - 2) ? '&page='. ($page - 1) : '')), 'prev');
			}

			if ($limit && ceil($product_total / $limit) > $page) {
			    $this->load->model('tool/path_manager'); $this->document->addLink($this->url->link('product/category', 'path=' . ($this->config->get('mlseo_fpp_cat_canonical') ? $this->model_tool_path_manager->getFullCategoryPath($category_info['category_id']) : $category_info['category_id']) . '&page='. ($page + 1)), 'next');
			}

			$data['sort'] = $sort;
			$data['order'] = $order;
			$data['limit'] = $limit;

			$data['continue'] = $this->url->link('common/home');

			$data['column_left'] = $this->load->controller('common/column_left');
			$data['column_right'] = $this->load->controller('common/column_right');
			$data['content_top'] = $this->load->controller('common/content_top');
			$data['content_bottom'] = $this->load->controller('common/content_bottom');
			$data['footer'] = $this->load->controller('common/footer');
			$data['header'] = $this->load->controller('common/header');

			$this->response->setOutput($this->load->view('product/category', $data));
		} else {
			$url = '';

			if (isset($this->request->get['path'])) {
				$url .= '&path=' . $this->request->get['path'];
			}

			if (isset($this->request->get['filter'])) {
				$url .= '&filter=' . $this->request->get['filter'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_error'),
				'href' => $this->url->link('product/category', $url)
			);

			$this->document->setTitle($this->language->get('text_error'));

			$data['continue'] = $this->url->link('common/home');

			$this->response->addHeader($this->request->server['SERVER_PROTOCOL'] . ' 404 Not Found');

			$data['column_left'] = $this->load->controller('common/column_left');
			$data['column_right'] = $this->load->controller('common/column_right');
			$data['content_top'] = $this->load->controller('common/content_top');
			$data['content_bottom'] = $this->load->controller('common/content_bottom');
			$data['footer'] = $this->load->controller('common/footer');
			$data['header'] = $this->load->controller('common/header');

			$this->response->setOutput($this->load->view('error/not_found', $data));
		}
	}
}
