<?php
/**
 * Simple autoloader for mPDF if Composer is not available.
 */

spl_autoload_register(function ($class) {

    // Only load classes from the Mpdf namespace
    if (strpos($class, 'Mpdf\\') === 0) {
        // Convert namespace to file path
        $path = __DIR__ . '/src/' . str_replace('\\', '/', substr($class, 5)) . '.php';
        
        if (file_exists($path)) {
            require_once $path;
        }
    }

    if (strpos($class, 'setasign\\Fpdi\\') === 0) {
        $path = __DIR__ . '/fpdi/src/' . str_replace('\\', '/', substr($class, 13)) . '.php';
        
        if (file_exists($path)) require_once $path;
    }

    if (strpos($class, 'Psr\\Log\\') === 0) {
        $path = __DIR__ . '/psr/Log/' . str_replace('\\', '/', substr($class, 8)) . '.php';
        if (file_exists($path)) require_once $path;
    }
});